;(function( fop2chatbroker, undefined) {

  var page = '';
  var bubble_color = '#1f2937';
  var autocreate_user = false;
  var text_color = '#ffffff';
  var lang = 'en';
  var theme = 'default';
  var avatar = '';
  var fingerprint = '';
  var customFingerprint = null;
  var useCustomFingerprint = false;
  var customHasher = null;
  var chatInput;
  var chatSubmit;
  var chatMessages;
  var chatBubble;
  var chatPopup;
  var closePopup;
  var chatNew;
  var chatCopy;
  var name='';
  var email='';
  var greeting='';
  var realtime_url='';
  var chat_disabled=0;
  var connected=0;
  var open_chat=0;
  var hook_path;

  var text = {};
  text['en']={};
  text['es']={};
  text['pt_BR']={};

  text['en']['contact_intro']='Please fill out the form below to start chatting with the next available agent.';
  text['en']['full_name']='Your full name';
  text['en']['email']='Your email';
  text['en']['start_chat']='Start Chat';
  text['en']['type']='Type your message...';
  text['en']['send']='Send';
  text['en']['you']='You';
  text['en']['agent']='Agent';
  text['en']['copychat']='Copy conversation';
  text['en']['newchat']='New conversation';
  text['en']['name_domain']='name@domain';
  text['en']['Documents']='Documents';
  text['en']['Photos & Videos']='Photos & Videos';
  text['en']['Screenshot']='Screenshot';

  text['es']['contact_intro']='Rellene el siguiente formulario para empezar a chatear con el siguiente agente disponible.';
  text['es']['full_name']='Su nombre completo';
  text['es']['email']='Su email';
  text['es']['start_chat']='Iniciar Chat';
  text['es']['type']='Escriba su mensaje...';
  text['es']['send']='Enviar';
  text['es']['you']='Usted';
  text['es']['agent']='Agente';
  text['es']['copychat']='Copiar conversación';
  text['es']['newchat']='Nueva conversación';
  text['es']['name_domain']='nombre@dominio';
  text['es']['Documents'] = 'Documentos';
  text['es']['Photos & Videos'] = 'Fotos y Videos';
  text['es']['Screenshot'] = 'Captura de pantalla';

  text['pt_BR']['contact_intro']='Por favor, preencha o formulário abaixo para começar o chat com o próximo agente disponível.';
  text['pt_BR']['full_name']='Seu nome completo';
  text['pt_BR']['email']='Seu email';
  text['pt_BR']['start_chat']='Iniciar Chat';
  text['pt_BR']['type']='Escreva a sua mensagem...';
  text['pt_BR']['send']='Enviar';
  text['pt_BR']['you']='Você';
  text['pt_BR']['agent']='Agente';
  text['pt_BR']['copychat']='Copiar conversa';
  text['pt_BR']['newchat']='Nova conversa';
  text['pt_BR']['name_domain']='nome@domínio';
  text['pt_BR']['Documents'] = 'Documentos';
  text['pt_BR']['Photos & Videos'] = 'Fotos e Vídeos';
  text['pt_BR']['Screenshot'] = 'Captura de tela';

  // Theme definitions
  var themes = {};

  // Default theme
  themes['default'] = `
#chat-input-y4M48UwqUx8k8i {
margin-right: 3px;
border: 1px solid #ddd;
border-radius: 6px;
padding: 2px 4px 0px 4px;
width:100%;
min-height:2.5em;
max-height: none;
overflow:hidden;
white-space: pre-wrap;
word-break: break-word;
}
#chat-input-y4M48UwqUx8k8i:focus {
outline: none;
box-shadow: none;
}
.clickable-image-y4M48UwqUx8k8i {
display: block;
    cursor: pointer;
    /* Critical fixes: */
    position: relative;
    z-index: 999; /* High z-index to ensure it's on top */
    pointer-events: auto !important; /* Force pointer events */
    /* Prevent image dragging which can interfere with clicks */
    -webkit-user-drag: none;
    -webkit-user-select: none;
    -moz-user-select: none;
    user-select: none;
    /* Ensure the image creates its own stacking context */
    isolation: isolate;
}
.clickable-image-y4M48UwqUx8k8i::before {
    content: '';
    position: absolute;
    top: -5px;
    left: -5px;
    right: -5px;
    bottom: -5px;
    z-index: 1000;
    cursor: pointer;
    background: transparent;
    /* This expanded clickable area should capture all clicks */
}
.attach_y4M48UwqUx8k8i {
  display: inline-block;
  position: relative;
  z-index: 10;
  cursor: pointer;
}
.all-y4M48UwqUx8k8i p, .all-y4M48UwqUx8k8i input {font-size:16px !important;}
.intro-y4M48UwqUx8k8i { margin: 0 0 20px 0; padding:0; text-align:left;}
.all-y4M48UwqUx8k8i,::after,::before{box-sizing:border-box;border-width:0;border-style:solid;border-color: currentColor;}
.hidden-y4M48UwqUx8k8i{display:none !important;}
button.y4M48UwqUx8k8i,input.y4M48UwqUx8k8i{font-family:inherit !important;font-size:100% !important;line-height:1.15 !important;margin:0 !important;}
button.y4M48UwqUx8k8i{text-transform:none !important;}
button.y4M48UwqUx8k8i{background-color:transparent;background-image:none;}
input.y4M48UwqUx8k8i::placeholder{opacity:1;color:#9ca3af;}
input.y4M48UwqUx8k8i{padding:.5em !important;}
button.y4M48UwqUx8k8i{cursor:pointer;}
button.y4M48UwqUx8k8i,input.y4M48UwqUx8k8i{padding:0;line-height:inherit;color:inherit;}
svg.y4M48UwqUx8k8i{display:block;vertical-align:middle;}
h3.y4M48UwqUx8k8i{font-size:1.125rem;font-weight:inherit;margin:0}
.y4M48UwqUx8k8i,::after,::before{--y4M48UwqUx8k8i-border-opacity:1;border-color:rgba(229,231,235,var(--y4M48UwqUx8k8i-border-opacity));}
.absolute-y4M48UwqUx8k8i{position:absolute;}
.right-0-y4M48UwqUx8k8i{right:0;}
.bottom-20-y4M48UwqUx8k8i{bottom:0.5rem;}
.m-0-y4M48UwqUx8k8i{margin:0;}
.mb-2-y4M48UwqUx8k8i{margin-bottom:.5rem;}
.mb-6-y4M48UwqUx8k8i{margin-bottom:1.5rem;}
.block-y4M48UwqUx8k8i{display:block;}
.flex-y4M48UwqUx8k8i{display:flex;}
.flexend-y4M48UwqUx8k8i{display:flex;align-items:flex-end !important;}
.h-6-y4M48UwqUx8k8i{height:1.5rem;}
.h-10-y4M48UwqUx8k8i{height:2.5rem;}
.h-16-y4M48UwqUx8k8i{height:4rem;}
.w-6-y4M48UwqUx8k8i{width:1.5rem;}
.w-10-y4M48UwqUx8k8i{width:2.5rem;}
.w-16-y4M48UwqUx8k8i{width:4rem;}
.w-96-y4M48UwqUx8k8i{width:24rem;}
.w-34-y4M48UwqUx8k8i{width:75%;}
.w-full-y4M48UwqUx8k8i{width:100%;}
.flex-1-y4M48UwqUx8k8i{flex:1 1 0%;}
.cursor-pointer-y4M48UwqUx8k8i{cursor:pointer;}
.flex-col-y4M48UwqUx8k8i{flex-direction:column;}
.items-centery-y4M48UwqUx8k8i{align-items:center;}
.justify-center-y4M48UwqUx8k8i{justify-content:center;}
.justify-between-y4M48UwqUx8k8i{justify-content:space-between;}
.space-x-4-y4M48UwqUx8k8i>:not([hidden])~:not([hidden]){--y4M48UwqUx8k8i-space-x-reverse:0;margin-right:calc(1rem * var(--y4M48UwqUx8k8i-space-x-reverse));margin-left:calc(1rem * calc(1 - var(--y4M48UwqUx8k8i-space-x-reverse)));}
.rounded-md-y4M48UwqUx8k8i{border-radius:.375rem;}
.rounded-lg-y4M48UwqUx8k8i{border-radius:.5rem;}
.rounded-full-y4M48UwqUx8k8i{border-radius:9999px;}
.rounded-t-md-y4M48UwqUx8k8i{border-top-left-radius:.375rem !important;border-top-right-radius:.375rem !important;}
.border-y4M48UwqUx8k8i{border-width:1px !important;}
.border-t-y4M48UwqUx8k8i{border-top-width:1px !important;}
.border-none-y4M48UwqUx8k8i-y4M48UwqUx8k8i{border-style:none !important;}
.border-gray-200-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-border-opacity:1;border-color:rgba(229,231,235,var(--y4M48UwqUx8k8i-border-opacity)) !important;}
.border-gray-300-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-border-opacity:1;border-color:rgba(209,213,219,var(--y4M48UwqUx8k8i-border-opacity)) !important;}
.bg-transparent-y4M48UwqUx8k8i{background-color:transparent;}
.bg-white-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-bg-opacity:1;background-color:rgba(255,255,255,var(--y4M48UwqUx8k8i-bg-opacity)) !important;}
.bg-gray-50-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-bg-opacity:1;background-color:rgba(249,250,251,var(--y4M48UwqUx8k8i-bg-opacity)) !important;}
.bg-gray-800-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-bg-opacity:1;background-color:rgba(31,41,55,var(--y4M48UwqUx8k8i-bg-opacity)) !important;}
.bg-blue-700-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-bg-opacity:1;background-color:rgba(29,78,216,var(--y4M48UwqUx8k8i-bg-opacity)) !important;}
.p-4-y4M48UwqUx8k8i{padding:1rem !important;}
.p-8-y4M48UwqUx8k8i{padding:2rem !important;}
.p-25-y4M48UwqUx8k8i{padding:.625rem !important;}
.px-4-y4M48UwqUx8k8i{padding-left:1rem;padding-right:1rem;}
.px-5-y4M48UwqUx8k8i{padding-left:1.25rem !important;padding-right:1.25rem !important;}
.py-2-y4M48UwqUx8k8i{padding-top:.5rem !important;padding-bottom:.5rem !important;}
.py-25-y4M48UwqUx8k8i{padding-top:.625rem !important;padding-bottom:.625rem !important;}
.pt-4-y4M48UwqUx8k8i{padding-top:1rem !important;}
.text-center-y4M48UwqUx8k8i{text-align:center !important;}
.text-xs-y4M48UwqUx8k8i{font-size:.75rem !important;line-height:1rem !important;}
.text-sm-y4M48UwqUx8k8i{font-size:.875rem !important;line-height:1.25rem !important;}
.text-lg-y4M48UwqUx8k8i{font-size:1.125rem !important;line-height:1.75rem;}
.text-3xl-y4M48UwqUx8k8i{font-size:1.875rem !important;line-height:2.25rem;}
.font-medium-y4M48UwqUx8k8i{font-weight:500;}
.text-white-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-text-opacity:1;color:rgba(255,255,255,var(--y4M48UwqUx8k8i-text-opacity)) !important;}
.text-red-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-text-opacity:1;color:rgba(200,15,15,var(--y4M48UwqUx8k8i-text-opacity)) !important;}
.text-gray-900-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-text-opacity:1;color:rgba(17,24,39,var(--y4M48UwqUx8k8i-text-opacity)) !important;}
y4M48UwqUx8k8i,::after,::before{--y4M48UwqUx8k8i-shadow:0 0 #0000;}
.shadow-md-y4M48UwqUx8k8i{--y4M48UwqUx8k8i-shadow:0 4px 6px -1px rgba(0, 0, 0, 0.1),0 2px 4px -1px rgba(0, 0, 0, 0.06);box-shadow:var(--y4M48UwqUx8k8i-ring-offset-shadow,0 0 #0000),var(--y4M48UwqUx8k8i-ring-shadow,0 0 #0000),var(--y4M48UwqUx8k8i-shadow);}
.outline-none-y4M48UwqUx8k8i-y4M48UwqUx8k8i{outline:2px solid transparent;outline-offset:2px;}
y4M48UwqUx8k8i,::after,::before{--y4M48UwqUx8k8i-ring-inset:var(--y4M48UwqUx8k8i-empty, );--y4M48UwqUx8k8i-ring-offset-width:0px;--y4M48UwqUx8k8i-ring-offset-color:#fff;--y4M48UwqUx8k8i-ring-color:rgba(59, 130, 246, 0.5);--y4M48UwqUx8k8i-ring-offset-shadow:0 0 #0000;--y4M48UwqUx8k8i-ring-shadow:0 0 #0000;}
.transition-all-y4M48UwqUx8k8i{transition-property:all;transition-timing-function:cubic-bezier(0.4,0,0.2,1);transition-duration:150ms;}
@media (min-width:640px){
.smw-auto-y4M48UwqUx8k8i{width:auto;}
}
#chat-widget-container-y4M48UwqUx8k8i{position:fixed;bottom:20px;right:20px;flex-direction:column;z-index:1000;}
#chat-popup-y4M48UwqUx8k8i{height:70vh;max-height:70vh;transition:all 0.3s;overflow:hidden;font-family:system-ui,-apple-system,'Segoe UI',Roboto,Helvetica,Arial,sans-serif,'Apple Color Emoji','Segoe UI Emoji';font-size:1em !important;}
@media (max-width: 768px){
#chat-popup-y4M48UwqUx8k8i{position:fixed;top:0;right:0;bottom:0;left:0;width:100%;height:100%;max-height:100%;border-radius:0;}
}
#close-popup-y4M48UwqUx8k8i {padding:0;width:1em;}
#chat-submit-y4M48UwqUx8k8i{padding:0.5rem;line-height:1.2rem;min-height:1.2rem;max-width:100px;font-weight:700;text-transform:none;border:none;cursor:pointer;border-radius:5px;background:#128c7e!important;}
#chat-submit-y4M48UwqUx8k8i:hover { background: #229c8e !important; }
.contact-y4M48UwqUx8k8i{padding:1em;display:none;}
.chat-y4M48UwqUx8k8i{display:flex;flex-direction:column-reverse;height:100%;font:1rem/1.5 "Open Sans", Arial;padding-bottom:2px;color:#313131;position:relative;overflow-y:scroll;overflow-x:hidden; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none;}
.chat__inner-y4M48UwqUx8k8i{display:flex;flex-direction:column;padding:0.75rem;}
.chat-y4M48UwqUx8k8i p {margin:0;padding:0;}
.chat__message-y4M48UwqUx8k8i{
width:100%;
display:flex;
align-items:flex-end;
transform-origin:0 100%;
padding-top:0;
--bgcolor:#d8d8d8;
--radius:12px 12px 12px 0;
pointer-events: auto;
}
.chat__message--new-y4M48UwqUx8k8i {
    transform: scale(0);
    max-height: 0;
    overflow: hidden;
    animation: message 0.15s ease-out 0s forwards;
    animation-delay: var(--timeline);
}
.chat__message_B-y4M48UwqUx8k8i{flex-direction:row-reverse;text-align:right;width:100%;align-self:flex-end;transform-origin:100%100%;--bgcolor:#d2ecd4;--radius:12px 12px 0 12px;}
.chat__content-y4M48UwqUx8k8i{flex:01auto;padding:1rem;margin:00.5rem;background:var(--bgcolor);border-radius:var(--radius);}
.chat__content-y4M48UwqUx8k8i > ul > li { list-style-type: none; border: 1px solid #333; border-radius: 2px; margin:3px 0 3px 0; padding:5px; font-size:16px;}
.chat__content-y4M48UwqUx8k8i > ul { margin:0; padding:0; }
.replyClick-y4M48UwqUx8k8i { border-radius: 5px !important; cursor: pointer; background: #eee;  }
.chat__message_A-y4M48UwqUx8k8i .bot-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    margin-right: 8px;
    margin-left: 2px;
    box-shadow: 0 1px 6px rgba(0,0,0,0.08);
    border: 2px solid #25d366;
    background: #fff;
    flex-shrink: 0;
}
@keyframes message { 0% {max-height:100vmax;} 80% {transform:scale(1.1);} 100% {transform:scale(1);max-height:100vmax;overflow:visible;padding-top:1rem;}}

   /* Modal styling */
    .modal-y4M48UwqUx8k8i {
      display: none;
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.8);
      justify-content: center;
      align-items: center;
      z-index: 1002;
    }
    .modal-content-y4M48UwqUx8k8i {
      max-width: 90%;
      max-height: 90%;
      object-fit: contain;
    }
    .modal-buttons-y4M48UwqUx8k8i {
      position: absolute;
      bottom: 20px;
      text-align: center;
      width: 100%;
    }
    .modal-buttons-y4M48UwqUx8k8i button {
      padding: 10px 20px;
      margin: 0 10px;
      cursor: pointer;
      background: #007bff;
      color: white;
      border: none;
      border-radius: 5px;
    }
    .modal-buttons-y4M48UwqUx8k8i button:hover {
      background: #0056b3;
    }
    .close-y4M48UwqUx8k8i {
      background: #dc3545;
    }
    .close-y4M48UwqUx8k8i:hover {
      background: #b02a37;
    }

    /* Upload attachment styles */
    .upload-container-y4M48UwqUx8k8i {
      position: relative;
      display: inline-block;
    }

    .upload-button-y4M48UwqUx8k8i {
      background: transparent;
      border: none;
      cursor: pointer;
      padding: 8px;
      border-radius: 50%;
      transition: background-color 0.2s;
    }

    .upload-button-y4M48UwqUx8k8i:hover {
      background-color: rgba(0, 0, 0, 0.1);
    }

    .upload-button-y4M48UwqUx8k8i svg {
      width: 20px;
      height: 20px;
      color: #6b7280;
    }

    .upload-button-y4M48UwqUx8k8i:hover svg {
      color: #374151;
    }

    .file-input-y4M48UwqUx8k8i {
      display: none !important;
    }

    .upload-menu-y4M48UwqUx8k8i {
      position: absolute;
      bottom: 100%;
      left: 0;
      background: white;
      border: 1px solid #e5e7eb;
      border-radius: 8px;
      padding: 8px 0;
      box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
      z-index: 1001;
      display: none;
      min-width: 12rem;
    }

    .upload-menu-item-y4M48UwqUx8k8i {
      padding: 8px 16px;
      cursor: pointer;
      display: flex;
      align-items: center;
      gap: 8px;
      color: #374151;
      font-size: 14px;
    }

    .upload-menu-item-y4M48UwqUx8k8i:hover {
      background-color: #f3f4f6;
    }

    .upload-menu-item-y4M48UwqUx8k8i svg {
      width: 16px;
      height: 16px;
      color: #6b7280;
    }

    .upload-preview-y4M48UwqUx8k8i {
      margin-top: 8px;
      padding: 8px;
      background: #f9fafb;
      border-radius: 6px;
      border: 1px dashed #d1d5db;
    }

    .upload-preview-item-y4M48UwqUx8k8i {
      display: flex;
      align-items: center;
      gap: 8px;
      padding: 4px 0;
      font-size: 12px;
      color: #374151;
    }

    .upload-preview-item-y4M48UwqUx8k8i svg {
      width: 16px;
      height: 16px;
      color: #6b7280;
    }

    .upload-remove-y4M48UwqUx8k8i {
      background: none;
      border: none;
      color: #ef4444;
      cursor: pointer;
      font-size: 14px;
      margin-left: auto;
    }
    /* Typing animation bubble */
    .typing-indicator-y4M48UwqUx8k8i {
      display: flex;
      align-items: center;
      padding: 10px 15px;
      background: #e5e7eb;
      border-radius: 18px 18px 18px 4px;
      margin: 8px 0;
      max-width: 80px;
    }

    .typing-dot-y4M48UwqUx8k8i {
      width: 8px;
      height: 8px;
      background: #6b7280;
      border-radius: 50%;
      margin: 0 2px;
      animation: typingAnimation 1.4s infinite ease-in-out;
    }

    .typing-dot-y4M48UwqUx8k8i:nth-child(1) { animation-delay: -0.32s; }
    .typing-dot-y4M48UwqUx8k8i:nth-child(2) { animation-delay: -0.16s; }

    @keyframes typingAnimation {
      0%, 80%, 100% { transform: scale(0.8); opacity: 0.5; }
      40% { transform: scale(1); opacity: 1; }
    }

/* Animaciones de la burbuja */
@keyframes bubble-out {
  0% { opacity: 1; transform: scale(1); }
  100% { opacity: 0; transform: scale(0.85); }
}
@keyframes bubble-in {
  0% { opacity: 0; transform: scale(0.85); }
  100% { opacity: 1; transform: scale(1); }
}
#chat-bubble-y4M48UwqUx8k8i {
  transition: opacity .25s ease, transform .25s ease;
  will-change: opacity, transform;
}
.bubble-hide-y4M48UwqUx8k8i {
  animation: bubble-out .25s forwards;
}
.bubble-show-y4M48UwqUx8k8i {
  animation: bubble-in .25s forwards;
}

/* Animación del POPUP */
#chat-popup-y4M48UwqUx8k8i {
  opacity: 0;
  transform: translateY(12px) scale(0.98);
  transition:
    opacity .28s ease,
    transform .28s cubic-bezier(.2,.8,.2,1),
    box-shadow .28s ease;
  will-change: opacity, transform;
  /* opcional: una sombra más suave al abrir */
  box-shadow: 0 8px 22px rgba(0,0,0,0.08);
}

.popup-open-y4M48UwqUx8k8i {
  opacity: 1 !important;
  transform: translateY(0) scale(1);
  box-shadow: 0 16px 32px rgba(0,0,0,0.12);
}

/* Respeto a usuarios con reducción de movimiento */
@media (prefers-reduced-motion: reduce) {
  #chat-popup-y4M48UwqUx8k8i {
    transition: none;
    transform: none;
  }
}
`;

  // WhatsApp theme
  themes['whatsapp'] = themes['default'] + `
.chat__message_A-y4M48UwqUx8k8i .bot-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    margin-right: 8px;
    margin-left: 2px;
    box-shadow: 0 1px 6px rgba(0,0,0,0.08);
    border: 2px solid #25d366;
    background: #fff;
    flex-shrink: 0;
}
#chat-popup-y4M48UwqUx8k8i {
    background: #ece5dd !important;
    border-radius: 12px !important;
    box-shadow: 0 4px 32px rgba(0,0,0,0.3);
    font-family: 'Segoe UI', 'Arial', 'sans-serif' !important;
    border: 1px solid #7e9b82;
}

#chat-header-y4M48UwqUx8k8i {
    background: #075e54 !important;
    color: #fff !important;
    font-size: 1.25em !important;
    font-weight: 600 !important;
    border-top-left-radius: 12px !important;
    border-top-right-radius: 12px !important;
    display: flex !important;
    align-items: center !important;
}

#chat-submit-y4M48UwqUx8k8i {
    background: #25d366 !important;
    color: #fff !important;
    font-weight: 600 !important;
    font-size: 1.1em !important;
    border-radius: 6px !important;
    border: none !important;
    box-shadow: 0 2px 8px rgba(37,211,102,0.18);
    transition: background 0.3s;
}
#chat-submit-y4M48UwqUx8k8i:hover {
    background: #128c7e !important;
}

.chat__message-y4M48UwqUx8k8i {
    margin: 0.3em 0;
    display: flex;
    align-items: flex-end;
    border: none !important;
    background: none !important;
}

.chat__message_A-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #fff !important;
    color: #222 !important;
    border-radius: 18px 18px 18px 0 !important;
    margin-right: 8px !important;
    margin-left: 0 !important;
    font-size: 1em !important;
    box-shadow: 0 1px 1px rgba(0,0,0,0.06);
    padding: 10px 18px !important;
    display: inline-block;
    max-width: 80%;
}

.chat__message_B-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #dcf8c6 !important;
    color: #222 !important;
    border-radius: 18px 18px 0 18px !important;
    margin-left: 8px !important;
    margin-right: 0 !important;
    font-size: 1em !important;
    box-shadow: 0 1px 1px rgba(0,0,0,0.06);
    padding: 10px 18px !important;
    display: inline-block;
    max-width: 80%;
}

#chat-input-container-y4M48UwqUx8k8i {
    background: #f7f7f7 !important;
    border-bottom-left-radius: 12px !important;
    border-bottom-right-radius: 12px !important;
}

`;

  // Modern theme
  themes['modern'] = themes['default'] + `
#chat-popup-y4M48UwqUx8k8i {
    border-radius: 15px !important;
    box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.2), 0 8px 10px -6px rgba(0, 0, 0, 0.2) !important;
    border: none !important;
    background: #f7f8fa !important;
}

#chat-header-y4M48UwqUx8k8i {
    background: linear-gradient(135deg, #007bff, #0056b3) !important;
    border-top-left-radius: 15px !important;
    border-top-right-radius: 15px !important;
    color: #ffffff !important;
    box-shadow: 0 2px 5px rgba(0,0,0,0.1);
}

#chat-bubble-y4M48UwqUx8k8i {
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease;
}
#chat-bubble-y4M48UwqUx8k8i:hover {
    transform: scale(1.1);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
}

.chat__message_A-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #ffffff !important;
    color: #333 !important;
    border-radius: 20px 20px 20px 5px !important;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
}

.chat__message_B-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #007bff !important;
    color: #ffffff !important;
    border-radius: 20px 20px 5px 20px !important;
    box-shadow: 0 2px 4px rgba(0,123,255,0.2);
}

#chat-input-y4M48UwqUx8k8i {
    border: 1px solid #e0e0e0 !important;
    border-radius: 10px !important;
    background: #ffffff !important;
    transition: all 0.2s ease;
}
#chat-input-y4M48UwqUx8k8i:focus {
    border-color: #007bff !important;
    box-shadow: 0 0 0 2px rgba(0,123,255,0.2) !important;
}

#chat-submit-y4M48UwqUx8k8i {
    background: #007bff !important;
    border-radius: 50% !important;
    display: flex;
    align-items: center;
    justify-content: center;
    box-shadow: 0 2px 5px rgba(0,123,255,0.25);
    transition: all 0.3s ease;
}
#chat-submit-y4M48UwqUx8k8i:hover {
    background: #0056b3 !important;
    transform: translateY(-2px);
}
#chat-submit-y4M48UwqUx8k8i svg {
    fill: #ffffff;
}

#chat-input-container-y4M48UwqUx8k8i {
    background: #f7f8fa !important;
    border-bottom-left-radius: 15px !important;
    border-bottom-right-radius: 15px !important;
}

.bot-avatar {
    border: 2px solid #007bff !important;
}
`;

  // Dark theme (custom)
  themes['dark'] = themes['default'] + `
.chat__message_A-y4M48UwqUx8k8i .bot-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    margin-right: 8px;
    margin-left: 2px;
    box-shadow: 0 1px 6px rgba(0,0,0,0.08);
    border: 2px solid #2c3698;
    background: #fff;
    flex-shrink: 0;
}
#chat-popup-y4M48UwqUx8k8i {
    background: #1a1a1a !important;
    border-radius: 12px !important;
    box-shadow: 0 4px 32px rgba(0,0,0,0.3);
    border: 1px solid #333;
}

#chat-header-y4M48UwqUx8k8i {
    background: #2d2d2d !important;
    color: #fff !important;
    border-top-left-radius: 12px !important;
    border-top-right-radius: 12px !important;
}

#chat-submit-y4M48UwqUx8k8i {
    background: #6366f1 !important;
    color: #fff !important;
    border-radius: 8px !important;
    border: none !important;
    box-shadow: 0 2px 8px rgba(99,102,241,0.3);
    transition: all 0.3s;
}
#chat-submit-y4M48UwqUx8k8i:hover {
    background: #4f46e5 !important;
    transform: translateY(-1px);
}

.chat-y4M48UwqUx8k8i {
    background: #1a1a1a !important;
    color: #e5e5e5 !important;
}

.chat__message_A-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #2d2d2d !important;
    color: #e5e5e5 !important;
    border-radius: 12px 12px 12px 4px !important;
    border: 1px solid #444;
    box-shadow: 0 2px 8px rgba(0,0,0,0.2);
}

.chat__message_B-y4M48UwqUx8k8i .chat__content-y4M48UwqUx8k8i {
    background: #6366f1 !important;
    color: #fff !important;
    border-radius: 12px 12px 4px 12px !important;
    box-shadow: 0 2px 8px rgba(99,102,241,0.3);
}

#chat-input-y4M48UwqUx8k8i {
    background: #2d2d2d !important;
    border: 1px solid #444 !important;
    color: #e5e5e5 !important;
    border-radius: 8px !important;
}

#chat-input-container-y4M48UwqUx8k8i {
    background: #1a1a1a !important;
    border-bottom-left-radius: 12px !important;
    border-bottom-right-radius: 12px !important;
    border-top: 1px solid #333;
}

.contact-y4M48UwqUx8k8i {
    background: #1a1a1a !important;
    color: #e5e5e5 !important;
}

.all-y4M48UwqUx8k8i input {
    background: #2d2d2d !important;
    border: 1px solid #444 !important;
    color: #e5e5e5 !important;
}

.all-y4M48UwqUx8k8i input::placeholder {
    color: #888 !important;
}
`;

  const loadScript = (FILE_URL, async = true, type = "text/javascript") => {
      return new Promise((resolve, reject) => {
          try {
              const scriptEle = document.createElement("script");
              scriptEle.type = type;
              scriptEle.async = async;
              scriptEle.src =FILE_URL;
              scriptEle.addEventListener("load", (ev) => {
                  resolve({ status: true });
              });
              scriptEle.addEventListener("error", (ev) => {
                  reject({
                      status: false,
                      message: `Failed to load the script ＄{FILE_URL}`
                  });
              });
              document.body.appendChild(scriptEle);
          } catch (error) {
              reject(error);
          }
      });
  };

;(function(name,context,definition) { if (typeof module !== 'undefined' && module.exports) { module.exports = definition(); } else if (typeof define === 'function' && define.amd) { define(definition); } else { context[name] = definition(); } } ) ('Fingerprint', this, function() { 'use strict'; var Fingerprint = function(options) { var nativeForEach, nativeMap; nativeForEach = Array.prototype.forEach; nativeMap = Array.prototype.map; this.each = function(obj, iterator, context) { if (obj === null) { return; } if (nativeForEach && obj.forEach === nativeForEach) { obj.forEach(iterator, context); } else if (obj.length === +obj.length) { for (var i = 0, l = obj.length; i < l; i++) { if (iterator.call(context, obj[i], i, obj) === {}) return; } } else { for (var key in obj) { if (obj.hasOwnProperty(key)) { if (iterator.call(context, obj[key], key, obj) === {}) return; } } } }; this.map = function(obj, iterator, context) { var results = []; if (obj == null) return results; if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context); this.each(obj, function(value, index, list) { results[results.length] = iterator.call(context, value, index, list); }); return results; }; if (typeof options == 'object') { this.hasher = options.hasher; this.screen_resolution = options.screen_resolution; this.screen_orientation = options.screen_orientation; this.canvas = options.canvas; this.ie_activex = options.ie_activex; } else if (typeof options == 'function') { this.hasher = options; } }; Fingerprint.prototype = { get: function() { var keys = []; keys.push(navigator.userAgent); keys.push(navigator.language); keys.push(screen.colorDepth); if (this.screen_resolution) { var resolution = this.getScreenResolution(); if (typeof resolution !== 'undefined') { keys.push(this.getScreenResolution().join('x')); } } keys.push(new Date().getTimezoneOffset()); keys.push(this.hasSessionStorage()); keys.push(this.hasLocalStorage()); keys.push(!!window.indexedDB); if (document.body) { keys.push(typeof(document.body.addBehavior)); } else { keys.push(typeof undefined); } keys.push(typeof(window.openDatabase)); keys.push(navigator.cpuClass); keys.push(navigator.platform); keys.push(navigator.doNotTrack); keys.push(this.getPluginsString()); if (this.canvas && this.isCanvasSupported()) { keys.push(this.getCanvasFingerprint()); } if (this.hasher) { return this.hasher(keys.join('###'), 31); } else { return this.murmurhash3_32_gc(keys.join('###'), 31); } }, murmurhash3_32_gc: function(key, seed) { var remainder, bytes, h1, h1b, c1, c2, k1, i; remainder = key.length & 3; bytes = key.length - remainder; h1 = seed; c1 = 0xcc9e2d51; c2 = 0x1b873593; i = 0; while (i < bytes) { k1 = ((key.charCodeAt(i) & 0xff)) | ((key.charCodeAt(++i) & 0xff) << 8) | ((key.charCodeAt(++i) & 0xff) << 16) | ((key.charCodeAt(++i) & 0xff) << 24); ++i; k1 = ((((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16))) & 0xffffffff; k1 = (k1 << 15) | (k1 >>> 17); k1 = ((((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16))) & 0xffffffff; h1 ^= k1; h1 = (h1 << 13) | (h1 >>> 19); h1b = ((((h1 & 0xffff) * 5) + ((((h1 >>> 16) * 5) & 0xffff) << 16))) & 0xffffffff; h1 = (((h1b & 0xffff) + 0x6b64) + ((((h1b >>> 16) + 0xe654) & 0xffff) << 16)); } k1 = 0; switch (remainder) { case 3: k1 ^= (key.charCodeAt(i + 2) & 0xff) << 16; case 2: k1 ^= (key.charCodeAt(i + 1) & 0xff) << 8; case 1: k1 ^= (key.charCodeAt(i) & 0xff); k1 = (((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16)) & 0xffffffff; k1 = (k1 << 15) | (k1 >>> 17); k1 = (((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16)) & 0xffffffff; h1 ^= k1; } h1 ^= key.length; h1 ^= h1 >>> 16; h1 = (((h1 & 0xffff) * 0x85ebca6b) + ((((h1 >>> 16) * 0x85ebca6b) & 0xffff) << 16)) & 0xffffffff; h1 ^= h1 >>> 13; h1 = ((((h1 & 0xffff) * 0xc2b2ae35) + ((((h1 >>> 16) * 0xc2b2ae35) & 0xffff) << 16))) & 0xffffffff; h1 ^= h1 >>> 16; return h1 >>> 0; }, hasLocalStorage: function() { try { return !!window.localStorage; } catch (e) { return true; } }, hasSessionStorage: function() { try { return !!window.sessionStorage; } catch (e) { return true; } }, isCanvasSupported: function() { var elem = document.createElement('canvas'); return !!(elem.getContext && elem.getContext('2d')); }, isIE: function() { if (navigator.appName === 'Microsoft Internet Explorer') { return true; } else if (navigator.appName === 'Netscape' && /Trident/.test(navigator.userAgent)) { return true; } return false; }, getPluginsString: function() { if (this.isIE() && this.ie_activex) { return this.getIEPluginsString(); } else { return this.getRegularPluginsString(); } }, getRegularPluginsString: function() { return this.map(navigator.plugins, function(p) { var mimeTypes = this.map(p, function(mt) { return [mt.type, mt.suffixes].join('~'); }).join(','); return [p.name, p.description, mimeTypes].join('::'); }, this).join(';'); }, getIEPluginsString: function() { if (window.ActiveXObject) { var names = ['ShockwaveFlash.ShockwaveFlash', 'AcroPDF.PDF', 'PDF.PdfCtrl', 'QuickTime.QuickTime', 'rmocx.RealPlayer G2 Control', 'rmocx.RealPlayer G2 Control.1', 'RealPlayer.RealPlayer(tm) ActiveX Control (32-bit)', 'RealVideo.RealVideo(tm) ActiveX Control (32-bit)', 'RealPlayer', 'SWCtl.SWCtl', 'WMPlayer.OCX', 'AgControl.AgControl', 'Skype.Detection' ]; return this.map(names, function(name) { try { new ActiveXObject(name); return name; } catch (e) { return null; } }).join(';'); } else { return ""; } }, getScreenResolution: function() { var resolution; if (this.screen_orientation) { resolution = (screen.height > screen.width) ? [screen.height, screen.width] : [screen.width, screen.height]; } else { resolution = [screen.height, screen.width]; } return resolution; }, getCanvasFingerprint: function() { var canvas = document.createElement('canvas'); var ctx = canvas.getContext('2d'); var txt = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!@#$%^&*()_+-={}|[]\:"<>?;,.'; ctx.textBaseline = "top"; ctx.font = "14px 'Arial'"; ctx.textBaseline = "alphabetic"; ctx.fillStyle = "#f60"; ctx.fillRect(125, 1, 62, 20); ctx.fillStyle = "#069"; ctx.fillText(txt, 2, 15); ctx.fillStyle = "rgba(102, 204, 0, 0.7)"; ctx.fillText(txt, 4, 17); return canvas.toDataURL(); } }; return Fingerprint;});

  fop2chatbroker.Setup = function(data) {
      page = data.page;
      page = page.toLowerCase().replace(/[:/]/g, '');
      if(data.lang!==undefined) {
          lang = data.lang;
      }
      if(data.bubble_color!==undefined) {
          bubble_color = data.bubble_color;
      }
      if(data.text_color!==undefined) {
          text_color = data.text_color;
      }
      if(data.autocreate_user!==undefined) {
          autocreate_user = data.autocreate_user;
      }
      if(data.theme!==undefined) {
          theme = data.theme;
      }
      if(data.avatar!==undefined) {
          avatar = data.avatar;
      }
      if(data.greeting!==undefined) {
          greeting = data.greeting;
      }
      if(data.form_fields !== undefined) {
          text[lang]['dynamic_fields'] = JSON.parse(data.form_fields);
      }
      if(data.force_open) {
          setTimeout(() => {
              const bubble = document.getElementById('chat-bubble-y4M48UwqUx8k8i');
              //bubble.classList.add('bubble-hide-y4M48UwqUx8k8i');
              togglePopup();
          }, 1000);
      }

      // Custom fingerprint configuration
      if(data.fingerprint_identity !== undefined) {
          customFingerprint = String(data.fingerprint_identity);
          useCustomFingerprint = true;
      }

      if(data.fingerprint_hasher !== undefined && typeof data.fingerprint_hasher === 'function') {
          // Wrap the custom hasher in a safe execution function
          customHasher = function(keys, seed) {
              try {
                  return data.fingerprint_hasher(keys, seed);
              } catch (error) {
                  console.error('Custom hasher function error:', error);
                  // Fallback to default murmurhash if custom hasher fails
                  var remainder, bytes, h1, h1b, c1, c2, k1, i;
                  remainder = keys.length & 3;
                  bytes = keys.length - remainder;
                  h1 = seed;
                  c1 = 0xcc9e2d51;
                  c2 = 0x1b873593;
                  i = 0;
                  while (i < bytes) {
                      k1 = ((keys.charCodeAt(i) & 0xff)) | ((keys.charCodeAt(++i) & 0xff) << 8) | ((keys.charCodeAt(++i) & 0xff) << 16) | ((keys.charCodeAt(++i) & 0xff) << 24);
                      ++i;
                      k1 = ((((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16))) & 0xffffffff;
                      k1 = (k1 << 15) | (k1 >>> 17);
                      k1 = ((((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16))) & 0xffffffff;
                      h1 ^= k1;
                      h1 = (h1 << 13) | (h1 >>> 19);
                      h1b = ((((h1 & 0xffff) * 5) + ((((h1 >>> 16) * 5) & 0xffff) << 16))) & 0xffffffff;
                      h1 = (((h1b & 0xffff) + 0x6b64) + ((((h1b >>> 16) + 0xe654) & 0xffff) << 16));
                  }
                  k1 = 0;
                  switch (remainder) {
                      case 3: k1 ^= (keys.charCodeAt(i + 2) & 0xff) << 16;
                      case 2: k1 ^= (keys.charCodeAt(i + 1) & 0xff) << 8;
                      case 1: k1 ^= (keys.charCodeAt(i) & 0xff);
                      k1 = (((k1 & 0xffff) * c1) + ((((k1 >>> 16) * c1) & 0xffff) << 16)) & 0xffffffff;
                      k1 = (k1 << 15) | (k1 >>> 17);
                      k1 = (((k1 & 0xffff) * c2) + ((((k1 >>> 16) * c2) & 0xffff) << 16)) & 0xffffffff;
                      h1 ^= k1;
                  }
                  h1 ^= keys.length;
                  h1 ^= h1 >>> 16;
                  h1 = (((h1 & 0xffff) * 0x85ebca6b) + ((((h1 >>> 16) * 0x85ebca6b) & 0xffff) << 16)) & 0xffffffff;
                  h1 ^= h1 >>> 13;
                  h1 = ((((h1 & 0xffff) * 0xc2b2ae35) + ((((h1 >>> 16) * 0xc2b2ae35) & 0xffff) << 16))) & 0xffffffff;
                  h1 ^= h1 >>> 16;
                  return h1 >>> 0;
              }
          };
      }

      setTimeout(() => {
        const bubble = document.getElementById('chat-bubble-y4M48UwqUx8k8i');
        bubble.style.display = ''; bubble.style.opacity = 1;}, 500);
      applyTheme(theme);
  }

  fop2chatbroker.sendReply = function(el) {
      const message = el.dataset.reply.trim();
      el.dataset.reply='';
      if (!message) return;
      const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
      chatContainer.scrollTop = 0;
      chatInput.innerHTML=''
      chatInput.textContent = '';
      chatInput.focus();
      onUserRequest(message);
  }

  // Function to change theme dynamically
  fop2chatbroker.setTheme = function(themeName) {
      theme = themeName;
      applyTheme(theme);
  }

  // Function to get available themes
  fop2chatbroker.getAvailableThemes = function() {
      return Object.keys(themes);
  }

  var fingerprint = "";

  // Function to apply theme
  function applyTheme(themeName) {
      // Remove any existing theme style element
      const existingStyle = document.getElementById('chat-widget-theme-y4M48UwqUx8k8i');
      if (existingStyle) {
          existingStyle.remove();
      }

      // Create new style element
      const style = document.createElement('style');
      style.id = 'chat-widget-theme-y4M48UwqUx8k8i';

      // Use the specified theme or fallback to default
      const selectedTheme = themes[themeName] || themes['default'];
      style.innerHTML = selectedTheme;

      document.head.appendChild(style);
  }

  // Apply initial theme (default)
  applyTheme(theme);

  hook_path = document.currentScript.src.substring(0, document.currentScript.src.lastIndexOf("/"));
  var url = new URL(hook_path);
  realtime_url = url.origin+"/realtime";

  const blip = new Audio(hook_path+"/blip.mp3");

  loadScript(hook_path+"/pocketbase.umd.js").then( data  => {
      injectWidget();
      bubble_container = document.getElementById('chat-bubble-y4M48UwqUx8k8i');
      header_container = document.getElementById('chat-header-y4M48UwqUx8k8i');
      submit_container = document.getElementById('chat-submit-y4M48UwqUx8k8i');

      bubble_text_element = document.getElementById('chat-bubble-y4M48UwqUx8k8i');
      header_text_element = document.getElementById('chat-header-text-y4M48UwqUx8k8i');
      close_text_element = document.getElementById('close-popup-y4M48UwqUx8k8i');

      bubble_container.style.backgroundColor = bubble_color;
      header_container.style.backgroundColor = bubble_color;
      submit_container.style.backgroundColor = bubble_color;

      submit_container.style.color = text_color;
      header_text_element.style.color = text_color;
      close_text_element.style.color = text_color;


      bubble_icon = document.getElementById('chat-bubble-icon-svg-y4M48UwqUx8k8i');
      bubble_icon.style.color = text_color;

   })
  .catch( err => {
        console.error(err);
  });


  function injectWidget() {

    const imageModal = document.createElement('div');
    imageModal.id = 'imageModal-y4M48UwqUx8k8i';
    imageModal.classList.add('modal-y4M48UwqUx8k8i');
    document.body.appendChild(imageModal);

      imageModal.innerHTML = `
    <img id="modalImage-y4M48UwqUx8k8i" class="modal-content-y4M48UwqUx8k8i" src="" alt="Full-size image">
    <div class="modal-buttons-y4M48UwqUx8k8i">
      <button id="downloadButton-y4M48UwqUx8k8i">Download</button>
      <button id="closeModal-y4M48UwqUx8k8i" class="close-y4M48UwqUx8k8i">Close</button>
    </div>
      `;
      // Create chat widget container
      const chatWidgetContainer = document.createElement('div');
      chatWidgetContainer.id = 'chat-widget-container-y4M48UwqUx8k8i';
      document.body.appendChild(chatWidgetContainer);

      // Generate dynamic fields
      let dynamicFieldsHTML = '';
      text[lang]['dynamic_fields'].forEach(field => {
        if (field.fieldtype === 'select') {
            dynamicFieldsHTML += `
                <div class="all-y4M48UwqUx8k8i mb-6-y4M48UwqUx8k8i">
                    <label for="${field.fieldname}" class="all-y4M48UwqUx8k8i block-y4M48UwqUx8k8i mb-2-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i font-medium-y4M48UwqUx8k8i text-gray-900-y4M48UwqUx8k8i">${field.fieldlabel}</label>
                    <select id="${field.fieldname}-y4M48UwqUx8k8i" class="y4M48UwqUx8k8i all-y4M48UwqUx8k8i bg-gray-50-y4M48UwqUx8k8i border-y4M48UwqUx8k8i border-gray-300-y4M48UwqUx8k8i text-gray-900-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i rounded-lg-y4M48UwqUx8k8i block-y4M48UwqUx8k8i w-full-y4M48UwqUx8k8i p-25-y4M48UwqUx8k8i" required>
                        ${field.options.map(option => `<option value="${option}">${option}</option>`).join('')}
                    </select>
                </div>
            `;
        } else {
            dynamicFieldsHTML += `
                <div class="all-y4M48UwqUx8k8i mb-6-y4M48UwqUx8k8i">
                    <label for="${field.fieldname}" class="all-y4M48UwqUx8k8i block-y4M48UwqUx8k8i mb-2-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i font-medium-y4M48UwqUx8k8i text-gray-900-y4M48UwqUx8k8i">${field.fieldlabel}</label>
                    <input type="${field.fieldtype}" id="${field.fieldname}-y4M48UwqUx8k8i" class="y4M48UwqUx8k8i all-y4M48UwqUx8k8i bg-gray-50-y4M48UwqUx8k8i border-y4M48UwqUx8k8i border-gray-300-y4M48UwqUx8k8i text-gray-900-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i rounded-lg-y4M48UwqUx8k8i block-y4M48UwqUx8k8i w-full-y4M48UwqUx8k8i p-25-y4M48UwqUx8k8i" required>
                </div>
            `;
        }
      });

      // Inject the HTML
      chatWidgetContainer.innerHTML = `
        <div id="chat-bubble-y4M48UwqUx8k8i" style="background-color: #ddd; display:none; opacity:0;" class="all-y4M48UwqUx8k8i w-16-y4M48UwqUx8k8i h-16-y4M48UwqUx8k8i xbg-gray-800-y4M48UwqUx8k8i rounded-full-y4M48UwqUx8k8i flex-y4M48UwqUx8k8i items-centery-y4M48UwqUx8k8i justify-center-y4M48UwqUx8k8i cursor-pointer-y4M48UwqUx8k8i text-3xl-y4M48UwqUx8k8i">
          <svg xmlns="http://www.w3.org/2000/svg" id="chat-bubble-icon-svg-y4M48UwqUx8k8i" class="y4M48UwqUx8k8i w-10-y4M48UwqUx8k8i h-10-y4M48UwqUx8k8i" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
            <path stroke-linecap="round" stroke-linejoin="round" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z" />
          </svg>
        </div>
        <div style='all:revert;'>
        <div id="chat-popup-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i hidden-y4M48UwqUx8k8i absolute-y4M48UwqUx8k8i bottom-20-y4M48UwqUx8k8i right-0-y4M48UwqUx8k8i w-96-y4M48UwqUx8k8i bg-white-y4M48UwqUx8k8i rounded-md-y4M48UwqUx8k8i shadow-md-y4M48UwqUx8k8i flex-y4M48UwqUx8k8i flex-col-y4M48UwqUx8k8i transition-all-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i">
          <div id="chat-header-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i flex-y4M48UwqUx8k8i justify-between-y4M48UwqUx8k8i items-centery-y4M48UwqUx8k8i p-4-y4M48UwqUx8k8i text-white-y4M48UwqUx8k8i rounded-t-md-y4M48UwqUx8k8i">
            <h3 class="y4M48UwqUx8k8i all-y4M48UwqUx8k8i m-0-y4M48UwqUx8k8i text-lg-y4M48UwqUx8k8i" id="chat-header-text-y4M48UwqUx8k8i">Chat</h3>
            <button id="close-popup-y4M48UwqUx8k8i" class="y4M48UwqUx8k8i all-y4M48UwqUx8k8i bg-transparent-y4M48UwqUx8k8i border-none-y4M48UwqUx8k8i cursor-pointer-y4M48UwqUx8k8i">
              <svg xmlns="http://www.w3.org/2000/svg" class="y4M48UwqUx8k8i h-6-y4M48UwqUx8k8i w-6-y4M48UwqUx8k8i" fill="none" viewBox="0 0 24 24" stroke="currentColor" stroke-width="2">
                <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
              </svg>
            </button>
          </div>
          <section class="contact-y4M48UwqUx8k8i all-y4M48UwqUx8k8i" id="contact-y4M48UwqUx8k8i">
             <p class="all-y4M48UwqUx8k8i intro-y4M48UwqUx8k8i">${text[lang]['contact_intro']}</p>
             <form id="contactform-y4M48UwqUx8k8i">
${dynamicFieldsHTML}
               <button type="submit" class="y4M48UwqUx8k8i all-y4M48UwqUx8k8i text-white-y4M48UwqUx8k8i bg-blue-700-y4M48UwqUx8k8i font-medium-y4M48UwqUx8k8i rounded-lg-y4M48UwqUx8k8i text-sm-y4M48UwqUx8k8i w-full-y4M48UwqUx8k8i smw-auto-y4M48UwqUx8k8i px-5-y4M48UwqUx8k8i py-25-y4M48UwqUx8k8i text-center-y4M48UwqUx8k8i">${text[lang]['start_chat']}</button>
             </form>
          </section>
          <section class="all-y4M48UwqUx8k8i chat-y4M48UwqUx8k8i" id="chat-y4M48UwqUx8k8i">
            <div id="chat__inner-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i"></div>
          </section>
          <div id="chat-input-container-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i p-4-y4M48UwqUx8k8i border-t-y4M48UwqUx8k8i border-gray-200-y4M48UwqUx8k8i">
          <div class="all-y4M48UwqUx8k8i flexend-y4M48UwqUx8k8i space-x-4-y4M48UwqUx8k8i items-centery-y4M48UwqUx8k8i">
              <div class="upload-container-y4M48UwqUx8k8i">
                <button id="upload-button-y4M48UwqUx8k8i" class="upload-button-y4M48UwqUx8k8i">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                    <path fill-rule="evenodd" d="M18.97 3.659a2.25 2.25 0 00-3.182 0l-10.94 10.94a3.75 3.75 0 105.304 5.303l7.693-7.693a.75.75 0 011.06 1.06l-7.693 7.693a5.25 5.25 0 11-7.424-7.424l10.939-10.94a3.75 3.75 0 115.303 5.304L9.097 18.835l-.008.008-.007.007-.002.002-.003.002A2.25 2.25 0 015.91 15.66l7.81-7.81a.75.75 0 011.061 1.06l-7.81 7.81a.75.75 0 001.054 1.068L18.97 6.84a2.25 2.25 0 000-3.182z" clip-rule="evenodd" />
                  </svg>
                </button>
                <div id="upload-menu-y4M48UwqUx8k8i" class="upload-menu-y4M48UwqUx8k8i">
                  <div class="upload-menu-item-y4M48UwqUx8k8i" data-type="images">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                      <path fill-rule="evenodd" d="M1.5 6a2.25 2.25 0 012.25-2.25h16.5A2.25 2.25 0 0122.5 6v12a2.25 2.25 0 01-2.25 2.25H3.75A2.25 2.25 0 011.5 18V6zM3 16.06V18c0 .414.336.75.75.75h16.5A.75.75 0 0021 18v-1.94l-2.69-2.689a1.5 1.5 0 00-2.12 0l-.88.879.97.97a.75.75 0 11-1.06 1.06l-5.16-5.159a1.5 1.5 0 00-2.12 0L3 16.061zm10.125-7.81a1.125 1.125 0 112.25 0 1.125 1.125 0 01-2.25 0z" clip-rule="evenodd" />
                    </svg>
                    ${text[lang]['Photos & Videos']}
                  </div>
                  <div class="upload-menu-item-y4M48UwqUx8k8i" data-type="documents">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                      <path d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0016.5 9h-1.875a1.875 1.875 0 01-1.875-1.875V5.25A3.75 3.75 0 009 1.5H5.625z" />
                      <path d="M12.971 1.816A5.23 5.23 0 0114.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 013.434 1.279 9.768 9.768 0 00-6.963-6.963z" />
                    </svg>
                    ${text[lang]['Documents']}
                  </div>
                  <div class="upload-menu-item-y4M48UwqUx8k8i" data-type="screenshot">
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                      <path fill-rule="evenodd" d="M3 6a3 3 0 013-3h12a3 3 0 013 3v12a3 3 0 01-3 3H6a3 3 0 01-3-3V6zm14.25 6a.75.75 0 01-.22.53l-2.25 2.25a.75.75 0 11-1.06-1.06L15.44 12l-1.72-1.72a.75.75 0 111.06-1.06l2.25 2.25c.141.14.22.331.22.53zm-10.28-.53a.75.75 0 000 1.06l2.25 2.25a.75.75 0 101.06-1.06L8.56 12l1.72-1.72a.75.75 0 10-1.06-1.06l-2.25 2.25z" clip-rule="evenodd" />
                    </svg>
                    ${text[lang]['Screenshot']}
                  </div>
                </div>
                <input type="file" id="file-input-y4M48UwqUx8k8i" class="file-input-y4M48UwqUx8k8i" multiple>
              </div>

              <span role="textbox" id="chat-input-y4M48UwqUx8k8i" contenteditable="true" placeholder="Enter your message..." style="cursor: pointer;"></span>

              <button id="chat-submit-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i rounded-md-y4M48UwqUx8k8i px-4-y4M48UwqUx8k8i py-2-y4M48UwqUx8k8i cursor-pointer-y4M48UwqUx8k8i" aria-label="${text[lang]['send']}" title="${text[lang]['send']}">
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24"> <path d="M2.01 21L23 12 2.01 3 2 10l15 2-15 2z" fill="currentColor"/> </svg>
              </button>
              <button id="chat-copy-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i rounded-md-y4M48UwqUx8k8i px-4-y4M48UwqUx8k8i py-2-y4M48UwqUx8k8i cursor-pointer-y4M48UwqUx8k8i w-full-y4M48UwqUx8k8i">${text[lang]['copychat']}</button>
              <button id="chat-new-y4M48UwqUx8k8i" class="all-y4M48UwqUx8k8i rounded-md-y4M48UwqUx8k8i px-4-y4M48UwqUx8k8i py-2-y4M48UwqUx8k8i cursor-pointer-y4M48UwqUx8k8i w-full-y4M48UwqUx8k8i">${text[lang]['newchat']}</button>
          </div>
          <div id="upload-preview-y4M48UwqUx8k8i" class="upload-preview-y4M48UwqUx8k8i hidden-y4M48UwqUx8k8i"></div>
          <div class="all-y4M48UwqUx8k8i flex-y4M48UwqUx8k8i text-center-y4M48UwqUx8k8i text-xs-y4M48UwqUx8k8i pt-4-y4M48UwqUx8k8i">
              <!-span class="flex-1-y4M48UwqUx8k8i"></span-->
          </div>
        </div>
        </div>
        </div>
      `;

      // Add event listeners
      chatInput    = document.getElementById('chat-input-y4M48UwqUx8k8i');
      chatSubmit   = document.getElementById('chat-submit-y4M48UwqUx8k8i');
      chatCopy     = document.getElementById('chat-copy-y4M48UwqUx8k8i');
      chatNew      = document.getElementById('chat-new-y4M48UwqUx8k8i');
      chatMessages = document.getElementById('chat__inner-y4M48UwqUx8k8i');
      chatBubble   = document.getElementById('chat-bubble-y4M48UwqUx8k8i');
      chatPopup    = document.getElementById('chat-popup-y4M48UwqUx8k8i');
      closePopup   = document.getElementById('close-popup-y4M48UwqUx8k8i');

      // Upload elements
      const uploadButton = document.getElementById('upload-button-y4M48UwqUx8k8i');
      const uploadMenu = document.getElementById('upload-menu-y4M48UwqUx8k8i');
      const fileInput = document.getElementById('file-input-y4M48UwqUx8k8i');
      const uploadPreview = document.getElementById('upload-preview-y4M48UwqUx8k8i');
      const menuItems = document.querySelectorAll('.upload-menu-item-y4M48UwqUx8k8i');

      const modal = document.getElementById('imageModal-y4M48UwqUx8k8i');
      const modalImage = document.getElementById('modalImage-y4M48UwqUx8k8i');
      const downloadButton = document.getElementById('downloadButton-y4M48UwqUx8k8i');
      const closeModal = document.getElementById('closeModal-y4M48UwqUx8k8i');

      // Upload functionality
      let selectedFiles = [];

      uploadButton.addEventListener('click', (e) => {
        e.stopPropagation();
        uploadMenu.style.display = uploadMenu.style.display === 'block' ? 'none' : 'block';
      });

      menuItems.forEach(item => {
        item.addEventListener('click', (e) => {
          e.stopPropagation();
          const type = item.dataset.type;
          if (type === 'images') {
            fileInput.accept = 'image/*,video/*';
            fileInput.click();
          } else if (type === 'documents') {
            fileInput.accept = '.pdf,.doc,.docx,.xls,.xlsx,.csv,.txt';
            fileInput.click();
          } else if (type === 'screenshot') {
            captureScreenshot();
          }
          uploadMenu.style.display = 'none';
        });
      });

      fileInput.addEventListener('change', (e) => {
        const files = Array.from(e.target.files);
        if (files.length > 0) {
          selectedFiles = [...selectedFiles, ...files];
          updatePreview();
        }
        fileInput.value = '';
      });

      document.addEventListener('click', (e) => {
        if (!uploadMenu.contains(e.target) && e.target !== uploadButton) {
          uploadMenu.style.display = 'none';
        }
      });

      function updatePreview() {
        uploadPreview.innerHTML = '';
        if (selectedFiles.length > 0) {
          uploadPreview.classList.remove('hidden-y4M48UwqUx8k8i');
          selectedFiles.forEach((file, index) => {
            const previewItem = document.createElement('div');
            previewItem.className = 'upload-preview-item-y4M48UwqUx8k8i';

            const extension = file.name.split('.').pop().toLowerCase();
            let iconSvg = '';

            if (['jpg', 'jpeg', 'png', 'gif', 'webp', 'bmp'].includes(extension)) {
              iconSvg = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                <path fill-rule="evenodd" d="M1.5 6a2.25 2.25 0 012.25-2.25h16.5A2.25 2.25 0 0122.5 6v12a2.25 2.25 0 01-2.25 2.25H3.75A2.25 2.25 0 011.5 18V6zM3 16.06V18c0 .414.336.75.75.75h16.5A.75.75 0 0021 18v-1.94l-2.69-2.689a1.5 1.5 0 00-2.12 0l-.88.879.97.97a.75.75 0 11-1.06 1.06l-5.16-5.159a1.5 1.5 0 00-2.12 0L3 16.061zm10.125-7.81a1.125 1.125 0 112.25 0 1.125 1.125 0 01-2.25 0z" clip-rule="evenodd" />
              </svg>`;
            } else if (['mp4', 'mov', 'avi', 'wmv', 'webm'].includes(extension)) {
              iconSvg = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                <path d="M4.5 4.5a3 3 0 00-3 3v9a3 3 0 003 3h8.25a3 3 0 003-3v-9a3 3 0 00-3-3H4.5zm0 1.5h8.25a1.5 1.5 0 011.5 1.5v9a1.5 1.5 0 01-1.5 1.5H4.5a1.5 1.5 0 01-1.5-1.5v-9a1.5 1.5 0 011.5-1.5zm4.5 4.5a.75.75 0 00-1.28.53v4.94a.75.75 0 001.28.53l3.25-2.47a.75.75 0 000-1.06L8.72 10.5z" />
              </svg>`;
            } else {
              iconSvg = `<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor">
                <path d="M5.625 1.5c-1.036 0-1.875.84-1.875 1.875v17.25c0 1.035.84 1.875 1.875 1.875h12.75c1.035 0 1.875-.84 1.875-1.875V12.75A3.75 3.75 0 0016.5 9h-1.875a1.875 1.5 0 01-1.875-1.875V5.25A3.75 3.75 0 009 1.5H5.625z" />
                <path d="M12.971 1.816A5.23 5.23 0 0114.25 5.25v1.875c0 .207.168.375.375.375H16.5a5.23 5.23 0 013.434 1.279 9.768 9.768 0 00-6.963-6.963z" />
              </svg>`;
            }

            previewItem.innerHTML = `
              ${iconSvg}
              <span>${file.name}</span>
              <button class="upload-remove-y4M48UwqUx8k8i" data-index="${index}">×</button>
            `;

            uploadPreview.appendChild(previewItem);
          });

          // Add remove event listeners
          document.querySelectorAll('.upload-remove-y4M48UwqUx8k8i').forEach(button => {
            button.addEventListener('click', (e) => {
              const index = parseInt(e.target.dataset.index);
              selectedFiles.splice(index, 1);
              updatePreview();
            });
          });
        } else {
          uploadPreview.classList.add('hidden-y4M48UwqUx8k8i');
        }
      }

      // Screenshot capture functionality
      async function captureScreenshot() {
        try {
          // Check if screen capture API is available
          if (!navigator.mediaDevices || !navigator.mediaDevices.getDisplayMedia) {
            alert('Screen capture is not supported in your browser. Please use a modern browser like Chrome, Firefox, or Edge.');
            return;
          }

          // Request screen capture
          const stream = await navigator.mediaDevices.getDisplayMedia({
            video: {
              cursor: 'always',
              displaySurface: 'window',
              logicalSurface: true
            },
            audio: false
          });

          // Create video element to capture the stream
          const video = document.createElement('video');
          video.srcObject = stream;
          video.autoplay = true;
          video.playsInline = true;

          // Wait for video to be ready
          await new Promise(resolve => {
            video.onloadedmetadata = resolve;
          });

          // Create canvas to capture the frame
          const canvas = document.createElement('canvas');
          canvas.width = video.videoWidth;
          canvas.height = video.videoHeight;
          const ctx = canvas.getContext('2d');

          // Draw the video frame to canvas
          ctx.drawImage(video, 0, 0, canvas.width, canvas.height);

          // Stop the stream
          stream.getTracks().forEach(track => track.stop());

          // Convert canvas to blob
          canvas.toBlob(async (blob) => {
            // Create file from blob
            const file = new File([blob], `screenshot-${Date.now()}.png`, {
              type: 'image/png',
              lastModified: Date.now()
            });

            // Add to selected files
            selectedFiles.push(file);
            updatePreview();

          }, 'image/png', 0.9);

        } catch (error) {
          console.error('Screenshot capture failed:', error);
          if (error.name !== 'NotAllowedError') {
            alert('Failed to capture screenshot: ' + error.message);
          }
        }
      }

      // Modify chatSubmit to handle file uploads
      chatSubmit.addEventListener('click', function(e) {
        const message = chatInput.textContent.trim();
        if (message || selectedFiles.length > 0) {
          const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
          chatContainer.scrollTop = 0;
          chatInput.innerHTML=''
          chatInput.textContent='';

          if (selectedFiles.length > 0) {
            e.preventDefault();
            uploadFiles(message);
          } else {
            onUserRequest(message);
          }
        }
      });

      async function uploadFiles(message) {
        const formData = {};
        text[lang]['dynamic_fields'].forEach(field => {
          const fieldElement = document.getElementById(`${field.fieldname}-y4M48UwqUx8k8i`);
          if (fieldElement) {
            formData[field.fieldname] = fieldElement.value;
          }
        });

        const attachments = [];
        let previewHTML = '';

        for (const file of selectedFiles) {
          const fileURL = URL.createObjectURL(file);


          let extension = file.name.split(".").pop().toLowerCase();
          let mime = mime_icon(extension);

          if (file.type.startsWith('image/')) {
            previewHTML += `<div style="position: relative; display: inline-block; margin-top: 5px;">
                              <img src="${fileURL}" alt="${file.name}" style="max-width: 300px; border-radius: 8px;">
                              <a href="${fileURL}" download="${file.name}" style="position: absolute; top: 5px; right: 5px; background: rgba(0,0,0,0.7); color: white; padding: 3px 6px; border-radius: 4px; font-size: 12px; text-decoration: none;">⬇️</a>
                            </div>`;
          } else if (file.type.startsWith('video/')) {
            previewHTML += `<div style="position: relative; display: inline-block; margin-top: 5px;">
                            <video width="300" controls><source src="${fileURL}"></video>
                            </div>`;
          } else {
            previewHTML += `<div style="display: flex; align-items: center; margin-top: 5px;">
                              ${mime}
                              <a href="${fileURL}" download="${file.name}" style="margin-left: 8px; color: #007bff; text-decoration: none;">${file.name}</a>
                            </div>`;
          }

          const base64 = await new Promise((resolve) => {
            const reader = new FileReader();
            reader.onload = () => resolve(reader.result.split(',')[1]);
            reader.readAsDataURL(file);
          });
          attachments.push({
            name: file.name,
            type: file.type,
            size: file.size,
            data: base64
          });
        }

        const data = {
          newmsg: message || '',
          id: fingerprint,
          page: page,
          attachments: attachments,
          ...formData
        };

        try {
          const response = await fetch(hook_path + '/helper.php', {
            method: 'POST',
            headers: {
              'Content-Type': 'application/json'
            },
            body: JSON.stringify(data)
          });

          const result = await response.json();
          console.log('Upload result:', result);

          const messageElement = document.createElement('div');
          messageElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_B-y4M48UwqUx8k8i chat__message--new-y4M48UwqUx8k8i';
          messageElement.innerHTML = `
            <div class="chat__content-y4M48UwqUx8k8i">
              <p>${message}</p>
              ${previewHTML}
            </div>
          `;
          chatMessages.appendChild(messageElement);

        } catch (error) {
          console.error('Upload error:', error);
          // Handle error display if needed
            const messageElement = document.createElement('div');
            messageElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_B-y4M48UwqUx8k8i chat__message--new-y4M48UwqUx8k8i';
            messageElement.innerHTML = `
              <div class="chat__content-y4M48UwqUx8k8i">
                <p>${message}</p>
                ${error}
              </div>
            `;
            chatMessages.appendChild(messageElement);


        } finally {
          selectedFiles = [];
          updatePreview();
        }
      }

      // Attached image onClick for full size preview and download
      chatMessages.addEventListener('click', (event) => {
        if (event.target.tagName === 'IMG' && event.target.classList.contains('clickable-image-y4M48UwqUx8k8i')) {
          const image = event.target;
          const originalUrl = getOriginalImageUrl(image.src);
          modalImage.src = originalUrl;
          modal.style.display = 'flex';
          downloadButton.onclick = () => {
            const link = document.createElement('a');
            link.href = originalUrl;
            link.download = originalUrl.split('/').pop().split('?')[0]; // Extract filename
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
          };
        }
      });

      function getOriginalImageUrl(thumbUrl) {
        return thumbUrl.replace(/\?thumb=300x0$/, '');
      }

      // Close modal on close button click
      closeModal.addEventListener('click', () => {
        modal.style.display = 'none';
        modalImage.src = ''; // Clear image to free memory
      });

      // Close modal when clicking outside the image
      modal.addEventListener('click', (e) => {
        if (e.target === modal) {
          modal.style.display = 'none';
          modalImage.src = ''; // Clear image
        }
      });

      chatInput.disabled=true;

      chatCopy.style.display='none';
      chatNew.style.display='none';

      chatCopy.addEventListener('click', function() {
          transcribeClipboard();
      });

      chatNew.addEventListener('click', function() {
          newChat();
      });

      chatSubmit.addEventListener('click', function() {
          const message = chatInput.textContent.trim();
          if (!message) return;
          const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
          chatContainer.scrollTop = 0;
          chatInput.innerHTML=''
          chatInput.textContent='';
          chatInput.focus();
          onUserRequest(message);
      });

      chatInput.addEventListener('keydown', function(event) {
          if (event.key === 'Enter') {
              event.preventDefault();
              chatSubmit.click();
          }
      });

      chatBubble.addEventListener('click', function() {
          togglePopup();
      });

      closePopup.addEventListener('click', function() {
          togglePopup();
      });

      var form = document.getElementById('chat-y4M48UwqUx8k8i');
      form.addEventListener("submit", send);
      var cform = document.getElementById('contactform-y4M48UwqUx8k8i');
      cform.addEventListener("submit", contactsend);
  }


  function refresh_messages(e) {
      if(e.action=='create') {
          if(e.record.direction=='outbound' || e.record.direction=='autoreply' || e.record.direction=='csat1' || e.record.direction=='csat2') {
              let attach = [e.record.id, e.record.attachment];
              reply(e.record.body,true,attach,true);
          } else if(e.record.direction=='info') {
              if(e.record.body.indexOf('Closed by')===0) {
                  setTimeout(function() {closeChat();},6000);
              }
          }
      }
  }

  function togglePopup() {
      const popup = document.getElementById('chat-popup-y4M48UwqUx8k8i');
      const isHidden = popup.classList.contains('hidden-y4M48UwqUx8k8i');

      if(isHidden) {
          if(useCustomFingerprint) {
              // Use predefined identity instead of browser fingerprint
              fingerprint = customFingerprint;
              //console.warn('Using custom fingerprint identity:', fingerprint);
          } else if(customHasher) {
              // Use custom hasher function
              fingerprint = new Fingerprint({
                  canvas: true,
                  screen_resolution: true,
                  screen_orientation: true,
                  hasher: customHasher
              }).get();
              //console.warn('Using custom hasher fingerprint:', fingerprint);
          } else {
              // Use default browser fingerprinting
              fingerprint = new Fingerprint({canvas: true, screen_resolution: true, screen_orientation: true}).get();
              //console.warn('Using default browser fingerprint:', fingerprint);
          }
          dita = { newchat: fingerprint, page: page, autocreate: 0 };
          if(autocreate_user===true) {
              dita = { newchat: fingerprint, page: page, autocreate: 1, name: fingerprint, email: 'auto@created.user', user_agent: navigator.userAgent };
          }
          fetch(hook_path+'/helper.php', {
              method: 'POST',
              body: JSON.stringify(dita)
          })
          .then(response=>response.json())
          .then(function(response) {
              bubble_icon = document.getElementById('chat-bubble-icon-svg-y4M48UwqUx8k8i');
              if(response.id) {
                 bubble_icon.style.color = text_color;
                 const chatContact = document.getElementById('contact-y4M48UwqUx8k8i');
                 const chatChat = document.getElementById('chat-y4M48UwqUx8k8i');
                 const chatInputContainer = document.getElementById('chat-input-container-y4M48UwqUx8k8i');

                 if(response.name) {
                     let userData;
                     try {
                         userData = JSON.parse(response.name);
                         text[lang]['dynamic_fields'].forEach(field => {
                             const fieldElement = document.getElementById(`${field.fieldname}-y4M48UwqUx8k8i`);
                             if (fieldElement && userData[field.fieldname] !== undefined) {
                                fieldElement.value = userData[field.fieldname];
                             }
                         });
                     } catch(e) {
                         const nameElement = document.getElementById('name-y4M48UwqUx8k8i');
                         if (nameElement) {
                             nameElement.value = response.name;
                         }
                     }
                 }

                 if(response.id=='none') {
                     // ask for contact info
                     chatContact.style.display = 'block';
                     chatChat.style.display = 'none';
                     chatInputContainer.style.display = 'none';
                 } else {
                     chatContact.style.display = 'none';
                     chatChat.style.display = 'flex';
                     connect_subscribe(response.id,response.domain);
                 }
                 showPopup();
            } else {
                bubble_icon.style.color="#DD1111";
                chat_disabled=1;
                console.error("Error");
            }
          });
      } else {
          if(chat_disabled==1) {
              return;
          } else {
              hidePopup();
          }
      }
  }

  function showPopup() {
    const popup  = document.getElementById('chat-popup-y4M48UwqUx8k8i');
    const bubble = document.getElementById('chat-bubble-y4M48UwqUx8k8i');

    popup.classList.remove('hidden-y4M48UwqUx8k8i');
    void popup.offsetWidth;
    popup.classList.add('popup-open-y4M48UwqUx8k8i');

    if (bubble) {
      bubble.classList.remove('bubble-show-y4M48UwqUx8k8i');
      bubble.classList.add('bubble-hide-y4M48UwqUx8k8i');

      // Handler seguro: sólo actúa cuando termina bubble-out
      bubble.addEventListener('animationend', function onHideEnd(e) {
        if (e.animationName !== 'bubble-out') return; // <- filtro crítico
        bubble.style.display = 'none';
      }, { once: true }); // <- evita que quede escuchando para futuras animaciones
    }

    document.getElementById('chat-input-y4M48UwqUx8k8i')?.focus();
  }

  function hidePopup() {
    const popup  = document.getElementById('chat-popup-y4M48UwqUx8k8i');
    const bubble = document.getElementById('chat-bubble-y4M48UwqUx8k8i');

    popup.classList.remove('popup-open-y4M48UwqUx8k8i');

    const onCloseEnd = (e) => {
      if (e.target !== popup) return;
      popup.classList.add('hidden-y4M48UwqUx8k8i');
      popup.removeEventListener('transitionend', onCloseEnd);
    };
    popup.addEventListener('transitionend', onCloseEnd);

      if (bubble) {
      // Mostrarla de nuevo y animación de entrada
      bubble.style.display = '';              // quita display:none
      void bubble.offsetWidth;                // reflow para reiniciar animación
      bubble.classList.remove('bubble-hide-y4M48UwqUx8k8i');
      bubble.classList.add('bubble-show-y4M48UwqUx8k8i');
    }
  }

  function printGreeting(animate) {
    if(greeting=='') { return; }
    const variables = {}
    var matches = greeting.match(/{{(\w+)}}/g) || [];
    matches.forEach(match => {
        const varName = match.replace(/[{}]/g, '');
        const fieldElement = document.getElementById(`${varName}-y4M48UwqUx8k8i`);
        if(fieldElement) {
            variables[varName]=fieldElement.value;
        }
    })
    greeting = greeting.replace(/{{(\w+)}}/g, (match, key) => variables[key] || '');
    reply(greeting,false,[],animate);
  }

  function connect_subscribe(userid,domain) {
      if(connected==1) return;
      fingerprint = userid;
      const pb = new PocketBase(realtime_url);
      pb.authStore.storageKey = "webchat_auth"; // to avoid collitions with fop2
      pb.collection('users').authWithPassword(fingerprint+'@webuser_'+domain.toLowerCase()+page+'_'+fingerprint+'.noemail',fingerprint+'').then((authData)=> {
          if(pb.authStore.isValid) {
              chatInput.disabled=false;
              pb.collection('messages').subscribe('*', function (e) {
                  refresh_messages(e);
              });
              const pageResult = pb.collection('incomingqueue').getList(1, 500, {
                  filter: 'state="assigned"||state="open"||state="bot"'
              }).then((pageResult) => {
                  if(pageResult.items.length > 0) {
                      printGreeting(false);
                      const msgResult = pb.collection('messages').getFullList(200, {sort: 'created', filter: 'conversation="'+pageResult.items[0].id+'"'}).then((msgResult)=> {
                          msgResult.forEach(msg => {
                              if(msg.direction=='inbound' || msg.direction=='outbound' || msg.direction=='autoreply') {
                                      if(msg.direction=='outbound' || msg.direction=='autoreply') {
                                          let attach = [msg.id, msg.attachment];
                                          reply(msg.body,false,attach);
                                      } else {
                                          printmsg(msg,false);
                                      }
                                 }
                          })
                      })
                  } else {
                      printGreeting(true);
                  }
              })
              connected=1;
          }
      }).catch((error) => {
        bubble_icon = document.getElementById('chat-bubble-icon-svg-y4M48UwqUx8k8i');
        chatInput   = document.getElementById('chat-input-y4M48UwqUx8k8i');
        chatPopup   = document.getElementById('chat-popup-y4M48UwqUx8k8i');
        bubble_icon.style.color="#DD1111";
        chat_disabled=1;
        chatInput.disabled=true;
        console.error("Error");
        chatPopup.classList.toggle('hidden-y4M48UwqUx8k8i');
      })
  }

  function onUserRequest(message) {
      // Display user message
      const messageElement = document.createElement('div');
      messageElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_B-y4M48UwqUx8k8i chat__message--new-y4M48UwqUx8k8i';
      messageElement.innerHTML = `
        <div class="chat__content-y4M48UwqUx8k8i"><p>
          ${message}
          </p>
        </div>
      `;
      chatMessages.appendChild(messageElement);
      const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
      chatContainer.scrollTop = 0;
      chatInput.textContent = '';
      chatInput.innerHTML = '';

      // Collect all form fields
      const formData = {};
      text[lang]['dynamic_fields'].forEach(field => {
          const fieldElement = document.getElementById(`${field.fieldname}-y4M48UwqUx8k8i`);
          formData[field.fieldname] = fieldElement.value;
      });

      data = { newmsg: message, id: fingerprint, page: page, ...formData };
      fetch(hook_path+'/helper.php', {
          method: 'POST',
          body: JSON.stringify(data)
      })
      .then(response=>response.json())
      .then(function(response) {
          console.log(response);
      });
  }

  function printmsg(msg,animate) {

      const url = new URL(hook_path);
      const baseHref = url.origin;
      const attachment = msg.attachment;
      var divattach = '';
      if (typeof (attachment) != 'undefined' && attachment.length > 0) {
        var allfiles = [];
        var queuemsgid = msg.id;
        var baseurl = baseHref+"/realtime/api/files/messages/" + queuemsgid;
        allfiles = attachment.map(file => `${baseurl}/${file}`);
        for (let i = 0; i < allfiles.length; i++) {
          let extension = allfiles[i].split(".").pop().toLowerCase();
          var parts_filename = allfiles[i].split("/").pop().split("_");
          parts_filename.pop();
          filename = parts_filename.join("_") + "." + extension;
          var mywidth = 200;
          if (extension == 'gif' || extension == 'jpeg' || extension == 'webp' || extension == 'png' || extension == 'jpg') {
            mywidth = 300;
            if (extension == 'webp') {
              mywidth = 190;
            }
            divattach += '<div class="attach_y4M48UwqUx8k8i" id="attach_' + queuemsgid + '"><img class="clickable-image-y4M48UwqUx8k8i" src="' + allfiles[i] + '?thumb=' + mywidth + 'x0" alt="image" style="max-width:' + mywidth + 'px;"/></div>';
          } else if (extension == 'mp4') {
            divattach += '<div id="attach_' + queuemsgid + '"><video width="300" controls><source src="' + allfiles[i] + '"></video></div>';
          } else if (extension.substr(0, 2) == 'og') {
            divattach += '<audio id="attach_' + queuemsgid + '" controls src="' + allfiles[i] + '"> <a href="' + allfiles[i] + '">Download audio</a></audio>';
          } else {
            let mime = mime_icon(extension);
            divattach += '<div id="attach_' + queuemsgid + '"><a href="' + allfiles[i] + '" download="' + filename + '">' + mime + ' ' + filename + '</a></div>';
          }
        }
      }

      const message = msg.body
      cmdresult = removeCloseIndicator(message)
      brmessage = cmdresult.modifiedString.replace(/(?:\r\n|\r|\n)/g, '<br>');

      if(cmdresult.modifiedString!='' || divattach !='' ) {
          const chatMessages = document.getElementById('chat__inner-y4M48UwqUx8k8i');
          const messageElement = document.createElement('div');
          if(animate===true) {
            replyElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_B-y4M48UwqUx8k8i chat__message--new-y4M48UwqUx8k8i';
          } else {
            messageElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_B-y4M48UwqUx8k8i';
          }
          messageElement.innerHTML = `
            <div class="chat__content-y4M48UwqUx8k8i">${divattach}<p>
              ${message}
              </p>
            </div>
          `;
          chatMessages.appendChild(messageElement);
          const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
          chatContainer.scrollTop = 0;
      }
  };

  function reply(message,interpretCommand,attachment,animate) {

      const url = new URL(hook_path);
      const baseHref = url.origin;
      var divattach = '';

      if (typeof (attachment) != 'undefined' && attachment.length > 0) {
        var allfiles = [];
        var queuemsgid = attachment.shift();
        var baseurl = baseHref+"/realtime/api/files/messages/" + queuemsgid;
        //allfiles = attachment.map(file => `${baseurl}/${file}`);
        allfiles = attachment[0].map(file => baseurl + "/" + file);
        for (let i = 0; i < allfiles.length; i++) {
          let extension = allfiles[i].split(".").pop().toLowerCase();
          var parts_filename = allfiles[i].split("/").pop().split("_");
          parts_filename.pop();
          filename = parts_filename.join("_") + "." + extension;
          var mywidth = 200;
          if (extension == 'gif' || extension == 'jpeg' || extension == 'webp' || extension == 'png' || extension == 'jpg') {
            mywidth = 300;
            if (extension == 'webp') {
              mywidth = 190;
            }
            divattach += '<div class="attach_y4M48UwqUx8k8i" id="attach_' + queuemsgid + '"><img class="clickable-image-y4M48UwqUx8k8i" src="' + allfiles[i] + '?thumb=' + mywidth + 'x0" alt="image" style="max-width:' + mywidth + 'px;"/></div>';
          } else if (extension == 'mp4') {
            divattach += '<div id="attach_' + queuemsgid + '"><video width="300" controls><source src="' + allfiles[i] + '"></video></div>';
          } else if (extension.substr(0, 2) == 'og') {
            divattach += '<audio id="attach_' + queuemsgid + '" controls src="' + allfiles[i] + '"> <a href="' + allfiles[i] + '">Download audio</a></audio>';
          } else {
            let mime = mime_icon(extension);
            divattach += '<div id="attach_' + queuemsgid + '"><a href="' + allfiles[i] + '" download="' + filename + '">' + mime + ' ' + filename + '</a></div>';
          }
        }
      }

      // message from bot or agent
      if(message.charCodeAt(0)==8) {
          resp = decodeSpecialText(message.slice(1));
          message = resp['formatted'];
      }

      cmdresult = removeCloseIndicator(message)
      brmessage = cmdresult.modifiedString.replace(/(?:\r\n|\r|\n)/g, '<br>');

      if(cmdresult.modifiedString!='' || divattach !='') {
          const chatMessages = document.getElementById('chat__inner-y4M48UwqUx8k8i');
          const replyElement = document.createElement('div');
          if(animate===true) {
            replyElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_A-y4M48UwqUx8k8i chat__message--new-y4M48UwqUx8k8i';
          } else {
            replyElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_A-y4M48UwqUx8k8i';
          }

          if(animate===true) {

              // Create typing indicator
              const typingElement = document.createElement('div');
              typingElement.className = 'chat__message-y4M48UwqUx8k8i chat__message_A-y4M48UwqUx8k8i';
              typingElement.innerHTML = `
                ${avatar ? `<img src="${avatar}" class="bot-avatar" alt="Agent Icon">` : ''}
                <div class="typing-indicator-y4M48UwqUx8k8i">
                  <div class="typing-dot-y4M48UwqUx8k8i"></div>
                  <div class="typing-dot-y4M48UwqUx8k8i"></div>
                  <div class="typing-dot-y4M48UwqUx8k8i"></div>
                </div>
              `;
              chatMessages.appendChild(typingElement);

              // Generate random delay between 2-6 seconds
              const randomDelay = Math.floor(Math.random() * 4000) + 2000; // 2 to 6 seconds

              // Remove typing indicator and show actual message after delay
              setTimeout(() => {
                  // Remove typing indicator
                  if (typingElement.parentNode) {
                      typingElement.parentNode.removeChild(typingElement);
                  }

                  // Create and append actual message
                  replyElement.innerHTML = `
                    ${avatar ? `<img src="${avatar}" class="bot-avatar" alt="Agent Icon">` : ''}
                    <div class="chat__content-y4M48UwqUx8k8i">${divattach}<p>
                      ${brmessage}</p>
                    </div>
                  `;
                  chatMessages.appendChild(replyElement);

                  const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
                  chatContainer.scrollTop = 0;
                  blip.play();

                  const popup = document.getElementById('chat-popup-y4M48UwqUx8k8i');
                  const isHidden = popup.classList.contains('hidden-y4M48UwqUx8k8i');
                  if(isHidden) {
                      showPopup();
                  }

                  if(cmdresult.closePresent==true && interpretCommand==true) {
                     closeChat();
                  }

              }, randomDelay);

          } else {
              replyElement.innerHTML = `
                ${avatar ? `<img src="${avatar}" class="bot-avatar" alt="Agent Icon">` : ''}
                <div class="chat__content-y4M48UwqUx8k8i">${divattach}<p>
                  ${brmessage}</p>
                </div>
              `;
              chatMessages.appendChild(replyElement);
              setTimeout(() => {
                  const chatContainer = document.getElementById('chat-y4M48UwqUx8k8i');
                  chatContainer.scrollTop = 0;
              }, 50);
              if(cmdresult.closePresent==true && interpretCommand==true) {
                 closeChat();
              }

          }
      }

  }

  function mime_icon(extension) {
    const iconSize = 48;
    if (extension == 'pdf') {
      return `<svg width="${iconSize}" height="${iconSize}" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#dc2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="#fef2f2"/>
        <polyline points="14,2 14,8 20,8" stroke="#dc2626" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <text x="12" y="16" text-anchor="middle" font-family="Arial, sans-serif" font-size="6" font-weight="bold" fill="#dc2626">PDF</text>
      </svg>`;
    } else if (extension == 'xls' || extension == 'xlsx') {
      return `<svg width="${iconSize}" height="${iconSize}" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#059669" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="#f0fdf4"/>
        <polyline points="14,2 14,8 20,8" stroke="#059669" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <line x1="8" y1="12" x2="16" y2="12" stroke="#059669" stroke-width="1"/>
        <line x1="8" y1="15" x2="16" y2="15" stroke="#059669" stroke-width="1"/>
        <line x1="8" y1="18" x2="16" y2="18" stroke="#059669" stroke-width="1"/>
        <line x1="10" y1="10" x2="10" y2="20" stroke="#059669" stroke-width="1"/>
        <line x1="14" y1="10" x2="14" y2="20" stroke="#059669" stroke-width="1"/>
      </svg>`;
    } else if (extension == 'doc' || extension == 'docx') {
      return `<svg width="${iconSize}" height="${iconSize}" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#2563eb" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="#eff6ff"/>
        <polyline points="14,2 14,8 20,8" stroke="#2563eb" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <line x1="8" y1="12" x2="16" y2="12" stroke="#2563eb" stroke-width="1"/>
        <line x1="8" y1="15" x2="16" y2="15" stroke="#2563eb" stroke-width="1"/>
        <line x1="8" y1="18" x2="13" y2="18" stroke="#2563eb" stroke-width="1"/>
      </svg>`;
    } else if (extension == 'zip' || extension == 'gz' || extension == 'tgz' || extension == 'rar') {
      return `<svg width="${iconSize}" height="${iconSize}" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#7c3aed" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="#faf5ff"/>
        <polyline points="14,2 14,8 20,8" stroke="#7c3aed" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
        <rect x="10" y="6" width="1" height="1" fill="#7c3aed"/>
        <rect x="11" y="7" width="1" height="1" fill="#7c3aed"/>
        <rect x="10" y="8" width="1" height="1" fill="#7c3aed"/>
        <rect x="11" y="9" width="1" height="1" fill="#7c3aed"/>
        <rect x="10" y="10" width="1" height="1" fill="#7c3aed"/>
        <rect x="11" y="11" width="1" height="1" fill="#7c3aed"/>
        <rect x="10" y="12" width="1" height="1" fill="#7c3aed"/>
        <rect x="11" y="13" width="1" height="1" fill="#7c3aed"/>
        <rect x="9" y="14" width="4" height="2" rx="1" stroke="#7c3aed" stroke-width="1" fill="none"/>
      </svg>`;
    } else {
      return `<svg width="${iconSize}" height="${iconSize}" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="#6b7280" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="#f9fafb"/>
        <polyline points="14,2 14,8 20,8" stroke="#6b7280" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
      </svg>`;
    }
  }

  function decodeSpecialText(data) {
      jsonObj = JSON.parse(data);
      response = {};

      body = '';
      context = '';

      if(jsonObj.type=='reply') {
          context = jsonObj.context;
          reply = jsonObj.body;
          response['formatted'] = "<div class='originalmsg' style='background-color:#d1f4cc; display:table; margin:0 0 5px 0; padding:0; width:100%;'><div style='display:table-cell; width:4px; background-color:#06cf9c; height:100%;'></div><div style='padding:5px;'>"+context+"</div></div>"+reply;
          response['raw'] = reply;
      } else if(jsonObj.type=='button') {
          body = jsonObj.body.text;
          let replyTitlesRaw = jsonObj.action.buttons.map(button => button.reply.title).join(',');
          response['formatted'] = body + '<ul>';
          jsonObj.action.buttons.forEach(title => {
             response['formatted'] += `<li class='replyClick-y4M48UwqUx8k8i' data-reply='${title.reply.title}' onClick='fop2chatbroker.sendReply(this)'>${title.reply.title}</li>`;
          });
          response['formatted']+='</ul>';
          response['raw'] = body+' '+replyTitlesRaw;
      }
      return response;
  }

  function newChat() {
      chatMessages.style.opacity='1';
      chatSubmit.disabled=false;
      chatSubmit.style.display='block';
      chatInput.disabled=false;
      chatInput.style.opacity='';
      chatInput.style.display='block';
      chatCopy.style.display='none';
      chatNew.style.display='none';

      while (chatMessages.firstChild) {
        chatMessages.removeChild(chatMessages.firstChild);
      }
      printGreeting();
  }

  function closeChat() {
      chatMessages.style.opacity='.5';
      chatSubmit.disabled=true;
      chatSubmit.style.display='none';
      chatInput.disabled=true;
      chatInput.style.opacity='.5';
      chatInput.style.display='none';
      chatCopy.style.display='block';
      chatNew.style.display='block';
  }

  function contactsend(event) {
      // submit contact form/info
      event.preventDefault();

      // Collect data from dynamic fields
      const formData = {};
      text[lang]['dynamic_fields'].forEach(field => {
        const fieldElement = document.getElementById(`${field.fieldname}-y4M48UwqUx8k8i`);
        formData[field.fieldname] = fieldElement.value;
      });

      data = { addcontact: 1, id: fingerprint, page: page, ...formData };
      fetch(hook_path+'/helper.php', {
          method: 'POST',
          body: JSON.stringify(data)
      })
      .then(response=>response.json())
      .then(function(response) {
          console.log(response);
          if(response.id!='') {
              document.getElementById('contact-y4M48UwqUx8k8i').style.display = 'none';
              document.getElementById('chat-y4M48UwqUx8k8i').style.display = 'flex';
              document.getElementById('chat-input-container-y4M48UwqUx8k8i').style.display = 'block';
              connect_subscribe(response.id,response.domain);
          }
      });
  }

  function send(event) {
      // send message
      var text = document.getElementById('msg').value;
      event.preventDefault();

      data = { newmsg: text, id: fingerprint, page: page, name: name, email: email };
      fetch(hook_path+'/helper.php', {
          method: 'POST',
          body: JSON.stringify(data)
      })
      .then(response=>response.json())
      .then(function(response) {
          console.log(response);
      });
  }

  function removeCloseIndicator(inputString) {
    const closeIndicator = /\[close\]/;
    const closePresent = closeIndicator.test(inputString);
    const modifiedString = inputString.replace(closeIndicator, '');
    return { modifiedString, closePresent };
  }

  function transcribeClipboard() {
    const chatContainer = document.getElementById("chat__inner-y4M48UwqUx8k8i");

    // Initialize an empty string to store the combined chat messages
    let chatText = "";

    // Iterate through each chat message
    const chatMessages = chatContainer.querySelectorAll(".chat__message-y4M48UwqUx8k8i");
    chatMessages.forEach((chatMessage) => {
      // Get the text content of the chat message
      const messageText = chatMessage.querySelector(".chat__content-y4M48UwqUx8k8i p").textContent.trim();
      const className = chatMessage.className;
      if (className.includes("chat__message_A")) {
          who = text[lang]['agent'];
      } else {
          who = text[lang]['you'];
      }

      // Add the message text to the combined chat text
      chatText += who+": "+messageText + '\n';
    });

    // Copy the combined chat text to the clipboard
    const textArea = document.createElement("textarea");
    textArea.value = chatText;
    document.body.appendChild(textArea);
    textArea.select();
    document.execCommand('copy');
    document.body.removeChild(textArea);
  }

}( window.fop2chatbroker = window.fop2chatbroker || {} ));
