URL = window.URL || window.webkitURL;

var input;
var isRecodrding = false;

var analyser;
var jsnode;

var opusrecorder;

// canvas
const canvas = document.querySelector(".visualizer");
const canvasCtx = canvas.getContext("2d");
let drawVisual;

function startstopRecording() {
    if($('#pttIcon').hasClass('fa-microphone')===true) {
        startRecording();
    } else {
        stopRecording();
    }
}

function startRecording() {

	console.log("startRecording() called");

    isRecording=true;

    // GUI Visuals
    $('.visualizer').show();
    $('#recordingsList').empty().hide();
    $('#controls').css('width','100%');
    $('.btnsmiley').hide();
    $('.btnattachmenu').hide();
    $('.msger-input').hide();
    $('#pttIcon').removeClass('fa-microphone').addClass('fa-stop-circle').css('color','red');

    // Audio Stuff
    const AudioContext = window.AudioContext || window.webkitAudioContext;
    const sourceNode = navigator.mediaDevices.getUserMedia({ audio : true }).then( ( stream ) => {
    const audioContext = new AudioContext();

        jsnode   = audioContext.createScriptProcessor(1024,1,1); //nuevo
        analyser = audioContext.createAnalyser();
        analyser.minDecibels = -90;
        analyser.maxDecibels = -10;
        analyser.smoothingTimeConstant = 0.85;

		input = audioContext.createMediaStreamSource(stream);

        input.connect(analyser);
        analyser.connect(jsnode); 
        jsnode.connect(audioContext.destination); 

        jsnode.onaudioprocess = function () {
            visualize();
        };

        return input;
     });

    var rec_options = {
        monitorGain: 0,
        recordingGain: 1,
        numberOfChannels: 1,
        encoderSampleRate: 48000,
        encoderPath: "js/encoderWorker.min.js",
        sourceNode: sourceNode
    };

    opusrecorder = new Recorder(rec_options);

    opusrecorder.start().catch(function(e) { __log("hubo un error: "+e.message);});

    opusrecorder.ondataavailable = function( typedArray ){
        __log('Data received');
        var dataBlob = new Blob( [typedArray], { type: 'audio/ogg' } );
        createDownloadLink(dataBlob,'ogg');
    };
}

function stopRecording() {

	console.log("stopRecording() called");
    isRecording=false;

    // GUI Visuals
    $('.msger-send-btn').css('background-color','#00c441');
    $('#pttIcon').addClass('fa-microphone').removeClass('fa-stop-circle').css('color','black');

    $('.visualizer').hide();
    opusrecorder.stop();
    jsnode.disconnect();
	
}

function createDownloadLink(blob,encoding) {

	var url = URL.createObjectURL(blob);
	var au = document.createElement('audio');
	//var link = document.createElement('a');
    var hid = document.createElement('input');
    hid.setAttribute("type", "hidden");
    hid.setAttribute("name", "audioblob");
    hid.setAttribute("id", "audioblob");


	//add controls to the <audio> element
	au.controls = true;
	au.src = url;

	//link the a element to the blob
	//link.href = url;
	//link.download = new Date().toISOString() + '.'+encoding;
	//link.innerHTML = link.download;

    $('.visualizer').hide();
    $('#recordTrash').show();

    var reader = new FileReader();
    reader.readAsDataURL(blob);
    reader.onloadend = function() {
        var base64data = reader.result;
        hid.setAttribute("value", base64data);
        $('#recordingsList').html(au).show();
        $('#recordingsList').append(hid);
    }

}

function __log(e, data) {
    console.log(e);
}

function trashRecording() {
    $('#recordingsList').empty();
    $('#recordTrash').hide();
    $('#controls').css('width','5rem');
    $('.msger-send-btn').css('background-color','#ccc');
    $('.btnsmiley').show();
    $('.btnattachmenu').show();
    $('.msger-input').show();
}

function visualize() {
    if (isRecording == false) {
        return;
    }
    WIDTH = canvas.width;
    HEIGHT = canvas.height;

    analyser.fftSize = 256;
    const bufferLengthAlt = analyser.frequencyBinCount;

    // See comment above for Float32Array()
    const dataArrayAlt = new Uint8Array(bufferLengthAlt);

    canvasCtx.clearRect(0, 0, WIDTH, HEIGHT);

    const drawAlt = function () {
        drawVisual = requestAnimationFrame(drawAlt);

        analyser.getByteFrequencyData(dataArrayAlt);

        canvasCtx.fillStyle = "rgb(241, 243, 244)";
        canvasCtx.fillRect(0, 0, WIDTH, HEIGHT);

        const barWidth = (WIDTH / bufferLengthAlt) * 2.5;
        let barHeight;
        let x = 0;

        for (let i = 0; i < bufferLengthAlt; i++) {
            barHeight = dataArrayAlt[i];
            canvasCtx.fillStyle = "rgb(" + (barHeight + 100) + ",50,50)";
            canvasCtx.fillRect( x, HEIGHT - barHeight / 2, barWidth, barHeight / 2);
            x += barWidth + 1;
        }
    };

    drawAlt();
}
