$('body').click(function (e) {
   if($(e.target).hasClass('btnsmiley') || $(e.target).hasClass('smileybtn') || $(e.target).hasClass('spanemoji') || $(e.target).hasClass('smileytab') || $(e.target).hasClass('emojisearchplaceholder')) {
       // do nothing if click is on open smiley button
   } else {
       if($('#emojibox').is(':visible')==true) {
           $('#emojibox').slideUp('fast',function() { });
           $('.smileybtn').removeClass('fa-window-close').addClass('fa-smile');
       }
   }
});

const capitalize = (name) => name.charAt(0).toUpperCase() + name.slice(1);
const divContainer = $("#allEmojis");

var recent_emojis = getRecentEmojis();
var pepemoji = {};
var descmoji = {};
var word = '';
var emoout;

function scrollCat(cat) {
  var elem = $(cat);
  if(elem) {
    var main = $("#allEmojis");

    main.scrollTop(0);
    var t = main.offset().top;
    main.scrollTop(elem.offset().top - t - 5);
  } else {
    console.log('categoria mal');
  }
}

function relPos(parentelement,childelement,scrollPos) {
    var parentPos = document.getElementById(parentelement).getBoundingClientRect(),
    childPos = document.getElementById(childelement).getBoundingClientRect(),
    relativePos = {};
    relativePos.top = childPos.top - parentPos.top + scrollPos - 10,
    relativePos.right = childPos.right - parentPos.right,
    relativePos.bottom = childPos.bottom - parentPos.bottom + scrollPos + 150,
    relativePos.left = childPos.left - parentPos.left;
    return relativePos;
}

function emojiScroll(event){
    var scrollPos = divContainer.scrollTop();
    
    $('#tabsListEmoji li a').each(function () {
        var currLink = $(this);
        var refElement = $(currLink.attr("href"));
        var mypos = relPos('allEmojis',refElement.attr('id'),scrollPos);
        if (scrollPos >= mypos.top && scrollPos <= mypos.bottom) {
            $('#tabsListEmoji li').removeClass('active');
            currLink.parent().addClass("active");
        }
        else{
            currLink.parent().removeClass("active");
        }
    });
    
}

function fetchJsonFromApi(apiUrl, logIt = true, modal = true) {
    return new Promise((resolve, reject) => {
      fetch(apiUrl)
        .then(response => response.json())
        .then(data => {
          resolve(data);
        })
        .catch(err => {
          console.log(err);
          reject(err);
        })
    });
};

var category_icons = { 
    'Recentemoji': '<i class="smileytab far fa-clock"></i>',
    'Smileys / people': '<i class="smileytab far fa-smile"></i>',
    'Objects': '<i class="smileytab far fa-lightbulb"></i>',
    'Nature': '<i class="smileytab fas fa-tree"></i>',
    'Symbols': '<i class="smileytab fas fa-hashtag"></i>',
    'Flags':'<i class="smileytab fas fa-flag"></i>',
    'Food':'<i class="smileytab fas fa-coffee"></i>',
    'Transportation / places':'<i class="smileytab fas fa-car"></i>',
    'Animals':'<i class="smileytab fas fa-cat"></i>',
    'Hands / arrows':'<i class="smileytab far fa-hand-point-up"></i>',
    'Buildings':'<i class="smileytab fas fa-building"></i>',
    'Sport':'<i class="smileytab far fa-futbol"></i>'
}

var category_names = { 
    'Smileys / people': parent.lang.smileyspeople,
    'Objects': parent.lang.objects, 
    'Nature': parent.lang.nature,
    'Symbols':  parent.lang.symbols,
    'Flags': parent.lang.flags,
    'Food': parent.lang.food,
    'Transportation / places': parent.lang.transportationplaces,
    'Animals': parent.lang.animals,
    'Hands / arrows': parent.lang.handsarrows,
    'Buildings': parent.lang.buildings,
    'Sport': parent.lang.sport,
}


document.addEventListener('DOMContentLoaded', (event) => {



    fetchJsonFromApi('emojis.json').then((data) => {
      let emojis = data.emojis;
      var mylang = getCookie('lang');
      if(mylang!==null) {
         keyw = 'keywords_'+mylang.split("_")[0];
      } else {
         keyw = 'keywords';
      }
      if(data.emojis[0][keyw]===undefined) {
         keyw = 'keywords';
      }
      for (var i = 0; i < emojis.length; i++) {

        pepemoji[data.emojis[i].shortcode]=data.emojis[i]['data-clipboard-text'];
        descmoji[data.emojis[i][keyw]+' '+data.emojis[i].title.toLowerCase()]=data.emojis[i].shortcode;

        if (i === 0 || emojis[i].category !== emojis[i - 1].category) {
          var active='';
          if(i===0) active='active';
          active='active';
          $("<div/>", {
            id: emojis[i].category,
            class: "tab-pane fade in emojitab "+active
          }).appendTo(divContainer);
          var cat = capitalize(emojis[i].category).replace("_", " / ");
          var catprint = category_names[cat];
          $("<h4>", {text: catprint, class: 'ml-10'}).appendTo("#" + emojis[i].category);
        }
        $("<span/>", {
          text: emojis[i]["#text"],
          "data-keywords": emojis[i][keyw],
          class: 'spanemoji',
          title: emojis[i].title + " | " + emojis[i].shortcode
        }).appendTo("#" + emojis[i].category);
      }

      // create emoji category tabs
      $("#allEmojis")
        .before('<ul class="nav nav-tabs mb-3" id="tabsListEmoji"></ul>')
        .children()
        .each(function (i, tab) {
          var cat = capitalize(tab.id).replace("_", " / ");
          if(cat!='') {
            var printcat = category_icons[cat];
            if(typeof(printcat)!='undefined') {
            $("#tabsListEmoji").append(
              $(`<li class="nav-item ${
                    i === 0 ? "active" : ""
                  }">
                  <a class="nav-link text-secondary smileytab ${
                    i === 0 ? "active" : ""
                  }" href="#${tab.id}" role="tab" data-toggle="scrolltab">
                    ${printcat}
                  </a></li>`)
            );
            }
          }
        });

        // click on emoji cateogry tab
        $('a[data-toggle="scrolltab"]').on('click',function(e) {
            e.preventDefault();
            filter_emoji('');
            $('#tabsListEmoji li').removeClass('active');
            $(this).parent().addClass('active');
            var target = this.hash;
            scrollCat(target);
        });

        $('#allEmojis').on("scroll", emojiScroll);

        $('.btnsmiley').on('click',function() {
           if($('#emojibox').is(':visible')==true) { 
               $('#emojibox').slideUp('fast',function() { });
               $('.smileybtn').removeClass('fa-window-close').addClass('fa-smile');
           } else {
               $('.smileybtn').addClass('fa-window-close').removeClass('fa-smile');
               if($('#recentemoji span').length==0) {
                   $('#lbl_recent').hide();
               } else {
                   $('#lbl_recent').show();
               }
               $('#emojibox').slideDown('fast',function() { });
           };
        });

        // insert recent emojis from localStorage
        for(i=0;i<recent_emojis.length;i++) {
            $("<span/>", {
                class: 'spanemoji',
                text: recent_emojis[i]
              }).insertAfter("#lbl_recent");
        }

    }); // end fetch
}); // end on ready

$(document).on("click", ".spanemoji", function () {
  const val = $(this).text();

  if(!recent_emojis.includes(val)) {
      $("<span/>", {
        text: val,
        class: 'spanemoji',
      }).insertAfter("#lbl_recent");
      recent_emojis.unshift(val);
      if(recent_emojis.length>30) { recent_emojis.pop(); }
      setRecentEmojis(recent_emojis);
      $('#lbl_recent').show();
  }

  var txt = $('#lbl_enteryourmessage');
  if($('#lbl_enteryourprivatenote').is(':visible')==true) {
      txt = $('#lbl_enteryourprivatenote');
  }
  var caretPos = txt.get(0).selectionStart;
  var caretEnd = txt.get(0).selectionEnd;
  var current = txt.val();
  txt.val(current.substring(0, caretPos) + val + current.substring(caretEnd) );
  txt.focus();
});

$(".emojisearchplaceholder").keyup(function () {
  var selectSize = $(this).val();
  console.log(selectSize);
  filter_emoji(selectSize);
});

// filter function
function filter_emoji(e) {
  if(e!='') {
      $('.spanemoji').hide();
      $('#allEmojis h4').hide();
  
      var regex = new RegExp("\\b\\w*" + e + "\\w*\\b");
      $(".spanemoji")
        .filter(function () {
          return regex.test($(this).data("keywords"));
        })
        .show();
  } else {
      $('.spanemoji').show();
      $('#allEmojis h4').show();
  }
}

//filter function when typing :
function filter_emojis() {

    var emojis = [];
    for (var key in pepemoji) {
        if (pepemoji.hasOwnProperty(key)) {
            if(key.startsWith(':'+word.toLowerCase())) {
                emojis.push(key);
            }
        }
    }

    for (var key in descmoji) {
        if (descmoji.hasOwnProperty(key)) {
            if(key.indexOf(word.toLowerCase().substring(1))>=0) {
                emojis.push(descmoji[key]);
            }
        }
    }

    emojis = emojis.filter(onlyUnique);

    if(emojis.length>0) {
        var html = '';
        for (var i = 0; i < emojis.length; i++) {
            html += '<div class="boxemj" style="float:left;"><button type="button" class="emojibtn" title="'+emojis[i]+'" data-clipboard-text="'+pepemoji[emojis[i]]+'">'+pepemoji[emojis[i]]+'</span></button></div>';
        }
        $('#emojis').html(html).slideDown('fast');
        trapFocus($('#emojis')[0]);
    } else {
        $('#emojis').html('<div><a href="" class="emojibtn"></a></div>');
        trapFocus($('#emojis')[0]);
    }
}


$(document).on('click','.boxemj',function(ev) {
    clipboard = ($(ev.target).find('.emoji').attr('data-clipboard-text')===undefined)?$(ev.target).attr('data-clipboard-text'):$(ev.target).find('.emoji').attr('data-clipboard-text');
    var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
    var message = $('#lbl_enteryourmessage').val();
    var searchRegExp = new RegExp(':'+word, 'g');
    var newmessage = message.replace(searchRegExp,clipboard);
    $('#lbl_enteryourmessage').val(newmessage).focus().selectRange(curPos-1);
    document.getElementById("lbl_enteryourmessage").selectionEnd = curPos - word.length + 1;
    $('#emojis').slideUp();
    word='';
});


function getRecentEmojis() {
    var ret = [];
    var rt = localStorage.getItem("recent_emojis");
    if(rt!=null) {
        ret = rt.split(",");
    } 
    return ret; 
}

function setRecentEmojis(rt) {
    var store = rt.join(",");
    localStorage.setItem("recent_emojis",store);
}

function trapFocus(element) {
  $(element).first('button').focus();
  var focusableEls = element.querySelectorAll('a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled])');
  var focusable = [...focusableEls];

  focusable[0].focus();

  $(element).off('keypress');
  $(element).off('keydown');

  $(element).on('keypress', function(e) {
      if(e.keyCode>=48 && e.keyCode<=122) {
          e.preventDefault();
          word += String.fromCharCode(e.keyCode);
          setTextToCurrentPos(String.fromCharCode(e.keyCode));

          if(String.fromCharCode(e.keyCode)==':' && word !='') {
              if(pepemoji[':'+word.toLowerCase()]!==undefined && word.length>1) {
                 clipboard = pepemoji[':'+word.toLowerCase()];
                 var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
                 var message = $('#lbl_enteryourmessage').val();
                 var searchRegExp = new RegExp(':'+word, 'g');
                 var newmessage = message.replace(searchRegExp,clipboard);
                 $('#lbl_enteryourmessage').val(newmessage).focus();
                 document.getElementById("lbl_enteryourmessage").selectionEnd = curPos - word.length + 1;
                 $('#emojis').slideUp();
                 setTimeout(function() { word=''; }, 500);
              } else {
                  console.log("no existe "+word.toLowerCase());
                  $('#emojis').slideUp();
                  var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
                  $('#lbl_enteryourmessage').focus().selectRange(curPos);
                  setTimeout(function() { word=''; }, 500);
              }
          } else {
              filter_emojis();
          }
      }
  })
  $(element).on('keydown', function(e) {
      var isRightPressed = (e.key === 'ArrowRight' || e.keyCode === 39);
      var isLeftPressed = (e.key === 'ArrowLeft' || e.keyCode === 37);

      const index = focusable.indexOf(document.activeElement);
      if(e.keyCode==9 || e.keyCode==13) {
          e.preventDefault();
          clipboard = $(document.activeElement).attr('data-clipboard-text');
          var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
          var message = $('#lbl_enteryourmessage').val();
          var searchRegExp = new RegExp(':'+word, 'g');
          var newmessage = message.replace(searchRegExp,clipboard);
          $('#lbl_enteryourmessage').val(newmessage).focus();
          document.getElementById("lbl_enteryourmessage").selectionEnd = curPos - word.length + 1;
          $('#emojis').slideUp();
          word='';

      } else if(e.keyCode==27) {
          e.preventDefault();
          $('#emojis').slideUp();
          $('#lbl_enteryourmessage').focus();
          word='';
      } else if(e.keyCode==8) {
          e.preventDefault();
          if(word=='') {
              // Se borró el dos puntos, ocultar emoji
              $('#emojis').slideUp();
              var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
              var message = $('#lbl_enteryourmessage').val();
              var newmessage = message.substring(0,curPos-1) + message.substring(curPos);
              $('#lbl_enteryourmessage').val(newmessage).focus().selectRange(curPos-1);
          } else {
              word = word.slice(0, -1);
              filter_emojis();
              var message = $('#lbl_enteryourmessage').val();
              var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
              var newmessage = message.substring(0,curPos-1) + message.substring(curPos);
              $('#lbl_enteryourmessage').val(newmessage);
              document.getElementById("lbl_enteryourmessage").selectionEnd = curPos-1;
          }
       
      }

      if (!isRightPressed && !isLeftPressed) {
          return;
      }

      if ( isLeftPressed ) {
          e.preventDefault();
          nextIndex = index > 0? index-1: 0;
          focusable[nextIndex].focus();
      } else {
          e.preventDefault();
          nextIndex = index +1 < focusable.length? index+1: index;
          focusable[nextIndex].focus();
      }
  });

  $('#emojis').scrollTop(2);
}

function setTextToCurrentPos(text_to_insert) {
    var curPos = document.getElementById("lbl_enteryourmessage").selectionStart;
    let x = $("#lbl_enteryourmessage").val();
    $("#lbl_enteryourmessage").val(x.slice(0, curPos) + text_to_insert + x.slice(curPos));
    document.getElementById("lbl_enteryourmessage").selectionEnd = curPos + text_to_insert.length;
}


function onlyUnique(value, index, array) {
  return array.indexOf(value) === index;
}

$('#emojis').on('focusout',function() {
    clearTimeout(emoout);
    emoout = setTimeout(function() {
      var dummyEl = document.getElementById('emojis');
      var isFocused = (document.activeElement === dummyEl);
      if(!isFocused) {
        if($(document.activeElement).hasClass('emojibtn')===false) {
          $('#emojis').slideUp();
          word='';
        }
      }
    },1000);
});
