var myCodeMirror;
var myCodeMirrorCRM;
var myCodeMirrorQR;
var myCodeMirrorAR;
var myCodeMirrorAH;
var myCodeMirrorCSATSurvey;
var myCodeMirrorCSATFeedback;
var myCodeMirrorCSATBye;
var myCodeMirrorTemplates;
var transfer_dictionary = {};
var jsonSteps = [];
var jsonFunctions = [];

document.addEventListener('DOMContentLoaded', (event) => {

    transfer_dictionary['ALL']=lang['All Extensions'];
    $('input[name="chatbroker_use_business_hours"]').first().parent().css('float','left').after('<div>&nbsp;(<a data-trans="manage" href="javascript:void(0);" onclick="javascript:bh();">manage</a>)</div>');

    $('.dtp').datetimepicker({ format: 'HH:mm', useCurrent: false });

    $(".dtp").on("dp.change", function (e) {
        var day = $(e.target).attr('id').split('_')[0];
        var when = $(e.target).attr('id').split('_')[1];
        if(when=='start') {
            $('#'+day+'_end').data("DateTimePicker").minDate(e.date);
        } else {
            $('#'+day+'_start').data("DateTimePicker").maxDate(e.date);
        }
    });

    $('.chk3').on('change',function(ev) {
         var day = $(ev.currentTarget).attr('id').split('_')[0];
         if (ev.currentTarget.checked) {
            $('#'+day+'_start').prop('disabled',false);
            $('#'+day+'_end').prop('disabled',false);
            if($('#'+day+'_start').val()=='') { $('#'+day+'_start').val('09:00') }
            if($('#'+day+'_end').val()=='') { $('#'+day+'_end').val('17:00') }
         } else {
            $('#'+day+'_start').val('').prop('disabled',true);;
            $('#'+day+'_end').val('').prop('disabled',true);;
         }
    });

    $('#businesshours').on('shown.bs.modal', function () {
        if(typeof(myCodeMirrorAH)=='undefined') {
        if($('#bhmsg').length>0) {
            myCodeMirrorAH = CodeMirror.fromTextArea($('#bhmsg')[0],{
              lineNumbers: true,
              lineWrapping: true,
              styleActiveLine: false,
              styleActiveSelected: false,
              mode: null,
              gutters: ["CodeMirror-lint-markers"],
              lint:false,
              extraKeys: {
                 "':'": startEmoji,
              }
            });
          myCodeMirrorAH.setSize(null,150);
        }
    }


    });

    $(document).on('change','#action-select',function() {
        var selectedFunction = $(this).val();
         if(selectedFunction=='') return;
        if (typeof window[selectedFunction] === 'function') {
            window[selectedFunction]();
            $('#action-select').val('');
        }
    });

    $('#businesshours').on('show.bs.modal', function () {
        val = $('#chatbroker_business_hours').val();
        msg = $('#chatbroker_after_hours_msg').val();
        $('#bhmsg').val(msg);
        if(val!='') {
            store_hours = JSON.parse($('#chatbroker_business_hours').val());

            for (const [key, value] of Object.entries(store_hours)) {
                  if(store_hours[key]['state']=='open') {
                     $('#'+key+'_enabled').prop('checked',true);
                     $('#'+key+'_start').val(store_hours[key]['start']);
                     $('#'+key+'_end').val(store_hours[key]['end']);
                  } else {
                     $('#'+key+'_enabled').prop('checked',false);
                     $('#'+key+'_start').val('').prop('disabled',true);
                     $('#'+key+'_end').val('').prop('disabled',true);
                  }
            }
            $('#timezone').val(store_hours['timezone']).trigger("chosen:updated");

        } else {
            $('.hourstart').val('');
            $('.hourend').val('');
        }
    })

    $('#businesshours').on('hide.bs.modal', function () {
         store_hours = {};
         $('.chk3').each(function(idx,el) {
             day = $(el).attr('name').split('_')[0];
             if($(el).is(':checked')) {
                state='open';
             } else {
                state='closed';
             }
             store_hours[day] = { "state": state };
         });
         $('.dtp').each(function(idx,el) {
             day = $(el).attr('id').split('_')[0];
             when = $(el).attr('id').split('_')[1];
             if(store_hours[day]['state']=='open') {
                 val = $(el).val();
             } else {
                 val = '';
             }
             store_hours[day][when] = val;
         });
         store_hours['timezone']=$('#timezone').val();
         $('#chatbroker_business_hours').val(JSON.stringify(store_hours));
         $('#chatbroker_after_hours_msg').val(myCodeMirrorAH.getValue());
    });

    if($('#chatbroker_template').length>0) {
        myCodeMirror = CodeMirror.fromTextArea($('#chatbroker_template')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: 'application/json',
          gutters: ["CodeMirror-lint-markers"],
          lint:true
        });
        myCodeMirror.setSize(null,150);
        if($('#chatbroker_template').val()=='') {
            updateTemplate(1);
        }
    }
    updateHelp();

    if($('#chatbroker_crmtemplate').length>0) {
        myCodeMirrorCRM = CodeMirror.fromTextArea($('#chatbroker_crmtemplate')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: 'application/json',
          gutters: ["CodeMirror-lint-markers"],
          lint:true
        });
        myCodeMirrorCRM.setSize(null,150);
        if($('#chatbroker_crmtemplate').val()=='') {
            updateCRMTemplate(1);
        }
    }

    // Quick Replies - Canned responses
    if($('#qrcontent').length>0) {
        myCodeMirrorQR = CodeMirror.fromTextArea($('#qrcontent')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
          }
        });
        myCodeMirrorQR.setSize(null,200);
    }

    // AutoReply
    if($('#chatbroker_autoreply').length>0) {
        myCodeMirrorAR = CodeMirror.fromTextArea($('#chatbroker_autoreply')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
          }
        });
        myCodeMirrorAR.setSize(null,150);
    }

    // CSAT Survey
    if($('#chatbroker_csat_msg').length>0) {
        myCodeMirrorCSATSurvey = CodeMirror.fromTextArea($('#chatbroker_csat_msg')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
          }
        });
        myCodeMirrorCSATSurvey.setSize(null,150);
    }

    // CSAT Feedback
    if($('#chatbroker_csat_feedback_msg').length>0) {
        myCodeMirrorCSATFeedback = CodeMirror.fromTextArea($('#chatbroker_csat_feedback_msg')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
          }
        });
        myCodeMirrorCSATFeedback.setSize(null,100);
    }

    // CSAT Bye
    if($('#chatbroker_csat_bye_msg').length>0) {
        myCodeMirrorCSATBye = CodeMirror.fromTextArea($('#chatbroker_csat_bye_msg')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
          }
        });
        myCodeMirrorCSATBye.setSize(null,100);
    }

    // CSAT Close Inactive
    if($('#chatbroker_csat_inactive_close_msg').length>0) {
        myCodeMirrorCSATInactiveClose = CodeMirror.fromTextArea($('#chatbroker_csat_inactive_close_msg')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: null,
          gutters: ["CodeMirror-lint-markers"],
          lint:true,
          extraKeys: {
             "':'": startEmoji,
        }

        });
        myCodeMirrorCSATInactiveClose.setSize(null,100);
    }

    // Whatsapp templates
    if($('#chatbroker_whatsapp_templates').length>0) {
        myCodeMirrorTemplates = CodeMirror.fromTextArea($('#chatbroker_whatsapp_templates')[0],{
          lineNumbers: true,
          lineWrapping: true,
          styleActiveLine: true,
          styleActiveSelected: true,
          mode: 'application/json',
          gutters: ["CodeMirror-lint-markers"],
          lint:true
        });
        myCodeMirrorTemplates.setSize(null,150);
    }


    if($('#chatbroker_engine').val()=='meta') {
        $('#chatbroker_whatsapp_templates').parent().parent().show();
        if (!$('#refresh_meta_templates_btn').length) {
            $('<button>')
                .attr({
                    'id': 'refresh_meta_templates_btn',
                    'type': 'button',
                    'class': 'btn btn-primary'
                })
                .text('Refresh Templates')
                .click(function(e) {
                    e.preventDefault();
                    refresh_meta_templates();
                })
                .insertBefore('#chatbroker_whatsapp_templates');
        }
    } else {
        $('#chatbroker_whatsapp_templates').parent().parent().hide();
        $('#refresh_meta_templates_btn').remove();
    }

    // Chatbot templates
    if($('#chatbot_template').length>0) {
        $('form').on('submit',function(event) {
             //event.preventDefault();
             var datastring = $('form').serialize();

             let urlParams = new URLSearchParams(datastring); // get interface / iterator
             let unserializedData = {}; // prepare result object
             for (let [key, value] of urlParams) { // get pair > extract it to key/value
                 unserializedData[key] = value;
             }
             original_template_data = JSON.parse(unserializedData['chatbot_template']);
             $.each(unserializedData, function(fieldName, fieldVal) {
                 if(fieldName.substr(0,8)=='dynamic_') {
                     if(typeof(original_template_data[fieldName.substr(8)])=='object') {
                         original_template_data[fieldName.substr(8)]['default']=fieldVal;
                     } else {
                         //something new not on stored db template, but updated in the code json definition
                         original_template_data[fieldName.substr(8)]={};
                         original_template_data[fieldName.substr(8)]['default']=fieldVal;
                     }
                     $('#'+fieldName).attr('disabled','disabled');
                 }
             });
             $('#chatbot_template').val(JSON.stringify(original_template_data));
        });
        updateChatbotTemplate(1);
    }

    $('#chatbot_type').on('change',function(uno,dos){
        updateChatbotTemplate(0);
    });

    $('#chatbroker_engine').on('change',function(){
        updateTemplate(0);
        updateHelp();
    });

    $('#chatbroker_crm').on('change',function(){
        updateCRMTemplate(0);
    });

    if($('input[name="chatbroker_enable_csat"]').is(':checked')===false) {
        $('#chatbroker_csat_msg').parent().parent().fadeOut();
        $('#chatbroker_csat_feedback_msg').parent().parent().fadeOut();
        $('#chatbroker_csat_bye_msg').parent().parent().fadeOut();
        $('#chatbroker_csat_inactive_close_msg').parent().parent().fadeOut();
    }

    $('input[name="chatbroker_enable_csat"]').on('change',function(ev){
       usecsat = $(ev.currentTarget).is(':checked');
       if(usecsat===true) {
           $('#chatbroker_csat_msg').parent().parent().fadeIn();
           $('#chatbroker_csat_feedback_msg').parent().parent().fadeIn();
           $('#chatbroker_csat_bye_msg').parent().parent().fadeIn();
           $('#chatbroker_csat_inactive_close_msg').parent().parent().fadeIn();
       } else {
           $('#chatbroker_csat_msg').parent().parent().fadeOut();
           $('#chatbroker_csat_feedback_msg').parent().parent().fadeOut();
           $('#chatbroker_csat_bye_msg').parent().parent().fadeOut();
           $('#chatbroker_csat_inactive_close_msg').parent().parent().fadeOut();
       }
    });

    if($('input[name="chatbroker_enable_ctia"]').is(':checked')===false) {
        $('#chatbroker_ctia_stop_msg').parent().parent().fadeOut();
        $('#chatbroker_ctia_stop_url').parent().parent().fadeOut();
        $('#chatbroker_ctia_help_msg').parent().parent().fadeOut();
    }

    $('input[name="chatbroker_enable_ctia"]').on('change',function(ev){
       usectia = $(ev.currentTarget).is(':checked');
       if(usectia===true) {
           $('#chatbroker_ctia_stop_msg').parent().parent().fadeIn();
           $('#chatbroker_ctia_stop_url').parent().parent().fadeIn();
           $('#chatbroker_ctia_help_msg').parent().parent().fadeIn();
       } else {
           $('#chatbroker_ctia_stop_msg').parent().parent().fadeOut();
           $('#chatbroker_ctia_stop_url').parent().parent().fadeOut();
           $('#chatbroker_ctia_help_msg').parent().parent().fadeOut();
       }
    });

    doTrans();

    $('#timezone').chosen();

    $('input').each(function() {
       if(typeof($(this).attr('name'))!='undefined') {
           if($(this).attr('name').indexOf('token')>=0) {
                $(this).addClass('confidential');
           }
       }
    });

    $('.toggle-on').text(lang.yes);
    $('.toggle-off').text(lang.no);

    if($('#steps-list').length>0) {
        var el = document.getElementById('steps-list');
        var sortable = Sortable.create(el,{onEnd: function(evt) {
            var oldindex = evt.oldIndex;  // element's old index within old parent
            var newindex = evt.newIndex;
            reorderJsonSteps(oldindex,newindex);
        }});
    }


    const inputField = document.getElementById('validation');
    if(inputField) {
    inputField.addEventListener('input', () => {
        const inputValue = inputField.value;
        if (isValidRegex(inputValue)) {
            inputField.classList.remove('invalid');
            inputField.classList.add('valid');
        } else {
            inputField.classList.remove('valid');
            inputField.classList.add('invalid');
        }
    });
    }

});

function isValidRegex(input) {
    try {
        new RegExp(input);
        return true;
    } catch (e) {
        return false;
    }
}

function reorderJsonSteps(dragIndex, dropIndex) {
    // Remove the dragged element from its original position
    const draggedStep = jsonSteps.splice(dragIndex, 1)[0];
    // Insert the dragged element at the new position
    if (dropIndex > dragIndex) {
        jsonSteps.splice(dropIndex - 1, 0, draggedStep);
    } else {
        jsonSteps.splice(dropIndex, 0, draggedStep);
    }
    updateStepsList();
    saveSteps();
}

function doTrans() {
    $('[data-trans]').each(function() {
         var newtext = '';
         if(typeof(lang[$(this).data('trans')])!='undefined') {
             newtext = lang[$(this).data('trans')];
         } else {
             newtext = $(this).data('trans');
         }

         $(this).text(newtext);
    });
}

function updateHelp() {
    $('#helpdid').remove();
    $('#helptemplate').remove();
    $('#helpengine').remove();
    engine = $('#chatbroker_engine').val();
    if(typeof(chatbrokertemplate)!='undefined') {
    if(typeof(chatbrokertemplate[engine])!='undefined') {
        let helpdata = JSON.parse(atob(chatbrokerfieldhelp[engine]));
        if(typeof(helpdata.did)=='string') {
            $('#chatbroker_did').parent().parent().children().first().append(`<i id="helpdid" style="margin:0 3px;" class="fa fa-question-circle iconhelp" data-toggle="popover" data-content="${helpdata.did}"></i>`);
        }
        if(typeof(helpdata.template)=='string') {
            $('#chatbroker_template').parent().parent().children().first().append(`<i id="helptemplate" style="margin:0 3px;" class="fa fa-question-circle iconhelp" data-toggle="popover" data-content="${helpdata.template}"></i>`);
        }
        if(typeof(helpdata.engine)=='string') {
            $('#chatbroker_engine').parent().parent().children().first().append(`<i id="helpengine" style="margin:0 3px;" class="fa fa-question-circle iconhelp" data-toggle="popover" data-content="${helpdata.engine}"></i>`);
        }
    }
    }
    $('[data-toggle="popover"]').popover({ container: 'body', html: true, trigger: 'hover' });
}

function updateChatbotTemplate(onload) {

    type = $('#chatbot_type').val();

    // Remove dbgrid hidden dynamic_ fields, otherwise they will probably cause errors when submitting
    // if they have any kind of special character. Besides we construct a template json entry with the data

    $('input[type="hidden"]').each(function() {
        if($(this).attr('name').substr(0,8)=='dynamic_') {
            $(this).remove();
        }
    });

    // clear all possible elements from other types
    $('#action-select').remove();
    $('#buttons-list').remove();
    $('#functions-list').remove();
    $('#steps-list').remove();
    $('#function-buttons-list').remove();

    if(typeof(chatbots[type])!='undefined') {
        $('.dynamic-template').remove();
        config = chatbots[type]['template'];

        // Render fields based on template
        where = $('#chatbot_template').parent().parent();
        where.find('label').hide();
        wherereal = $('#chatbot_template').parent().parent().parent();
        $('#chatbot_template').parent().hide();
        var dynamic_field_count = 0;
        $.each(config, function(fieldName, fieldProps) {
            dynamic_field_count++;
            var fgroup = $('<div class="form-group dynamic-template">');
            var inputField;
            if (fieldProps.type === "text") {
                inputField = $('<input type="text" class="form-control">');
            } else if (fieldProps.type === "number") {
                inputField = $('<input type="number" class="form-control">');
            } else if (fieldProps.type === "textarea") {
                inputField = $('<textarea class="form-control" rows="10"></textarea>');
            } else if (fieldProps.type === "select") {
                inputField = $('<select class="form-control"></select>');
                $.each(fieldProps.options, function(key, val) {
                    var option = $('<option>', {
                        value: key,
                        text: val
                    });
                    if (String(key).toLowerCase() == String(fieldProps.default).toLowerCase()) {
                        option.attr('selected', 'selected');
                    }
                    inputField.append(option);
                });
            } else {
                return false;
            }
            inputField.attr('name', 'dynamic_'+fieldName);
            inputField.attr('id', 'dynamic_'+fieldName);
            if(fieldProps.type!='select') {
                inputField.val(fieldProps.default);
            }
            var divField = $('<div class="col-sm-9">');
            var fieldNamePrint = capitalizeWords(fieldName.replace(/_/g, ' '));
            var label = $('<label class="control-label col-sm-2" data-trans="'+fieldNamePrint+'">').text(fieldNamePrint);
            fgroup.append(label);
            divField.append(inputField);
            fgroup.append(divField);
            wherereal.append(fgroup);
        });

        // Set field values if there are saved ones
        if(onload==1) {
            if($('#chatbot_template').val()!='') {
                // Edit existing
                if($('#chatbot_type').val()=='interactive_bot') {
                    conf = JSON.parse($('#chatbot_template').val());
                    if(typeof(conf.steps)!='undefined') {
                        jsonSteps = JSON.parse(conf.steps);
                    }
                    render_interactive();
                } else if($('#chatbot_type').val()=='openai_assistant') {
                    conf = JSON.parse($('#chatbot_template').val());
                    if(typeof(conf.functions)=='undefined') {
                        conf.functions = '[]';
                    }
                    jsonFunctions = JSON.parse(conf.functions);
                    render_functions();
                }
                saved_template = JSON.parse($('#chatbot_template').val());
                $.each(saved_template, function(fieldName, fieldProps) {
                    $('#dynamic_'+fieldName).val(fieldProps.default);
                });
            } else {
                // Add new
                $('#chatbot_template').val(JSON.stringify(config));
            }
        } else {
            // Type onChange select event
            if($('#chatbot_type').val()=='interactive_bot') {
                $('#chatbot_template').val(JSON.stringify(config));
                render_interactive();
            } else if($('#chatbot_type').val()=='openai_assistant') {
                $('#chatbot_template').val(JSON.stringify(config));
                render_functions();
            } else {
                $("#functions-list").remove();
                $("#function-buttons-list").remove();
                $("#steps-list").remove();
                $("#buttons-list").remove();
                $('#chatbot_template').val(JSON.stringify(config));
            }
        }
        if(dynamic_field_count>6) {
            // add toggle to hide/show config options
            var firstDynamicElement = $('.dynamic-template').first();
            var toggleButton = $('<button>', {
                id: 'toggleFieldsBtn',
                class: 'btn btn-primary btn-xs',
                'data-trans': 'Show Fields',
                text: 'Show Fields'
            });

            var wrapperDiv = $('<div>', {
                class: 'col-sm-2 col-sm-offset-9',
                style: 'padding-bottom: 20px; text-align:right;'
            });

            if($('#toggleFieldsBtn').length==0) {
                wrapperDiv.append(toggleButton);
                wrapperDiv.insertBefore(firstDynamicElement);
            }

            let fieldsVisible = false;
            $('.dynamic-template').hide();

            toggleButton.off('click').on('click', function(e) {
                e.preventDefault();
                $('.dynamic-template').toggle();
                fieldsVisible = !fieldsVisible;
                $(this).text(fieldsVisible ? lang['Hide Fields'] : lang['Show Fields']);
            });
        }
        doTrans();
    }
}


function capitalizeWords(str) {
    return str.replace(/\b\w/g, function(match) {
        return match.toUpperCase();
    });
}

function updateTemplate(force) {
    engine = $('#chatbroker_engine').val();
    if(typeof(chatbrokertemplate[engine])!='undefined') {
         content = chatbrokertemplate[engine];
         if(content=='') {
             $('#chatbroker_template').next('.CodeMirror').hide();
             //$('.CodeMirror').hide();
         } else {
             content = atob(content);
             $('#chatbroker_template').next('.CodeMirror').show();
             //$('.CodeMirror').show();
             myCodeMirror.refresh();
             $('#chatbroker_template').val(content);
             myCodeMirror.setValue(content);
             myCodeMirror.refresh();
         }
    }

    if(typeof(chatbrokericon[engine])!='undefined') {
        $('#chatbroker_icon').val(chatbrokericon[engine]);
    }

    if(engine=='meta') {
        $('#chatbroker_whatsapp_templates').parent().parent().show();
    } else {
        $('#chatbroker_whatsapp_templates').parent().parent().hide();
    }
}

function updateCRMTemplate(force) {
    crm = $('#chatbroker_crm').val();
    if(typeof(crmtemplate[crm])!='undefined') {
         $('#chatbroker_crmtemplate').next('.CodeMirror').parent().parent().show();
         content = crmtemplate[crm];
         if(content=='') {
             $('#chatbroker_crmtemplate').next('.CodeMirror').hide();
         } else {
             content = atob(content);
             $('#chatbroker_crmtemplate').next('.CodeMirror').show();
             myCodeMirrorCRM.refresh();
             $('#chatbroker_crmtemplate').val(content);
             myCodeMirrorCRM.setValue(content);
             myCodeMirrorCRM.refresh();
         }
    } else {
         $('#chatbroker_crmtemplate').next('.CodeMirror').parent().parent().hide();
    }
}

function bh() {
    $('#businesshours').modal();
}

function getCookie(name) {
    var cname = name + "=";
    var dc = document.cookie;
    if (dc.length > 0) {
        var begin = dc.indexOf(cname);
        if (begin != -1) {
            begin += cname.length;
            end = dc.indexOf(";", begin);
            if (end == -1) {
                end = dc.length;
            }
            return unescape(dc.substring(begin, end));
        }
    }
    return null;
}

function editFunctionStep(stepIndex) {
  const step = jsonFunctions[stepIndex];
  $("#function-modal input[name='stepnumber']").val(stepIndex);
  $("#function-modal input[name='functionname']").val(step.name);
  $("#function-modal input[name='functionurl']").val(step.url);
  $("#function-modal").modal("show");
}

function newFunctionModal() {
    $("#function-modal input[name='stepnumber']").val('');
    $("#function-modal input[name='functionname']").val('');
    $("#function-modal input[name='functionurl']").val('');
    $('#function-modal').modal('show');
    return false;
}

function newWaitModal() {
    $("#text-wait-modal input[name='stepnumber']").val('');
    $("#text-wait-modal textarea[name='message']").val('');
    $("#text-wait-modal textarea[name='response']").val('');
    $("#text-wait-modal input[name='wait']").val('');
    $('#text-wait-modal').modal('show');
    return false;
}

function newTextModal() {
    $("#text-question-modal input[name='stepnumber']").val('');
    $("#text-question-modal textarea[name='question']").val('');
    $('#text-question-modal').modal('show');
    return false;
}

function newFileModal() {
    $("#file-step-modal input[name='stepnumber']").val('');
    $("#file-step-modal input[name='url']").val('');
    $('#file-step-modal').modal('show');
    return false;
}

function newRangeModal() {
    $("#range-question-modal input[name='stepnumber']").val('');
    $("#range-question-modal textarea[name='question']").val('');
    $("#range-question-modal input[name='options']").val('');
    $('#range-question-modal').modal('show');
    return false;
}

function newMenuModal() {
    $("#menu-question-modal input[name='stepnumber']").val('');
    $("#menu-question-modal textarea[name='question']").val('');
    $('#menu-options').empty();
    $('#menu-question-modal').modal('show');
    return false;
}

function newRouteModal() {
    $("#route-modal input[name='stepnumber']").val('');
    $('#menu-route-options').empty();
    $('#route-next-step-nomatch').val('');
    $('#route-next-step-afterhours').val('');
    $('#route-next-step-from').val('');
    $('#route-next-step-from_goto').val('');
    $('#route-next-step-apivariable').val('');
    $('#route-next-step-apivariablecontent').val('');
    $('#route-next-step-apivariablegoto').val('');

    $('#route-modal').modal('show');
    return false;
}

function newApiCallModal() {
    $("#apicall-modal input[name='stepnumber']").val('');
    $('#apicall-httpmethod').val('');
    $('#apicall-url').val('');
    $('#apicall-headers').val('');
    $('#apicall-body').val('');
    $('#apicall-modal').modal('show');
    return false;
}

function newTransferModal() {
    $("#transfer-step-modal input[name='stepnumber']").val('');
    $("#transfer-step-modal textarea[name='question']").val('');
    $("#transfer-step-modal select[name='department']").val('');
    $('#transfer-step-modal').modal('show');
    return false;
}

function newTagModal() {
    $("#tag-step-modal input[name='stepnumber']").val('');
    $("#tag-step-modal textarea[name='question']").val('');
    $('#tag-step-modal').modal('show');
    return false;
}


function newCloseModal() {
    $("#close-step-modal input[name='stepnumber']").val('');
    $("#close-step-modal textarea[name='question']").val('');
    $('#close-step-modal').modal('show');
    return false;
}

function addFunction() {
    const stepnumber = $("#function-modal input[name='stepnumber']").val();
    const name = $("#function-modal input[name='functionname']").val();
    const url = $("#function-modal input[name='functionurl']").val();
    $("#function-modal").modal('hide');
    if(stepnumber=='') {
       jsonFunctions.push({
         name: name,
         url: url
       });
    } else {
       jsonFunctions[stepnumber]={
         name: name,
         url: url
       };
    }
    updateFunctionsList();
    saveFunctions();
}

function addFileStep() {
    const stepnumber = $("#file-step-modal input[name='stepnumber']").val();
    const url = $("#file-step-modal input[name='url']").val();
    $("#file-step-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: url,
         response_type: "file",
         next_action: "next",
       });
    } else {
       jsonSteps[stepnumber]={
         body: url,
         response_type: "file",
         next_action: "next",
       };
    }
    updateStepsList();
    saveSteps();
}

function addWaitStep() {
    const stepnumber = $("#text-wait-modal input[name='stepnumber']").val();
    const wait = $("#text-wait-modal input[name='wait']").val();
    const response = $("#text-wait-modal textarea[name='response']").val();
    const message = $("#text-wait-modal textarea[name='message']").val();
    $("#text-wait-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: message,
         response: response,
         wait: wait,
         response_type: "wait",
         next_action: "same",
       });
    } else {
       jsonSteps[stepnumber]={
         body: message,
         response: response,
         wait: wait,
         response_type: "wait",
         next_action: "same",
       };
    }
    updateStepsList();
    saveSteps();
}

function addTextQuestionStep() {
    const stepnumber = $("#text-question-modal input[name='stepnumber']").val();
    const question = $("#text-question-modal textarea[name='question']").val();
    const validation = $("#text-question-modal input[name='validation']").val();
    const incorrectmsg = $("#text-question-modal input[name='incorrectmsg']").val();
    $("#text-question-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: question,
         validation: validation,
         incorrectmsg: incorrectmsg,
         response_type: "text",
         next_action: "next",
       });
    } else {
       jsonSteps[stepnumber]={
         body: question,
         validation: validation,
         incorrectmsg: incorrectmsg,
         response_type: "text",
         next_action: "next",
       };
    }
    updateStepsList();
    saveSteps();
}

function addRangeQuestionStep() {
    const stepnumber = $("#range-question-modal input[name='stepnumber']").val();
    const question = $("#range-question-modal textarea[name='question']").val();
    const options = $("#range-question-modal input[name='options']").val().split(",").map(Number);
    $("#range-question-modal").modal('hide');
    if(stepnumber=='') {
        jsonSteps.push({
            body: question,
            response_type: "range",
            options: options,
            next_action: "next",
        });
    } else {
        jsonSteps[stepnumber]={
            body: question,
            response_type: "range",
            options: options,
            next_action: "next",
        };
    }
    updateStepsList();
    saveSteps();
}

function addMenuQuestionStep() {
    const stepnumber = $("#menu-question-modal input[name='stepnumber']").val();
    const question = $("#menu-question-modal textarea[name='question']").val();
    const options = {};
    let optionNumber = 1;
    while (true) {
        const optionLabel = $("#menu-question-modal input#option-label-" + optionNumber).val();
        if (!optionLabel) break;
        const nextStep = $("#menu-question-modal input#next-step-" + optionNumber).val();
        options[optionLabel] = Number(nextStep);
        optionNumber++;
    }
    $("#menu-question-modal").modal('hide');
    if(stepnumber=='') {
        jsonSteps.push({
            body: question,
            response_type: "menu",
            options: options,
        });
    } else {
        jsonSteps[stepnumber]={
            body: question,
            response_type: "menu",
            options: options,
        }
    }
    updateStepsList();
    saveSteps();
}

function addApiCallStep() {
    const stepnumber = $("#apicall-modal input[name='stepnumber']").val();
    const httpmethod = $("#apicall-httpmethod").val();
    const url = $("#apicall-url").val();
    const headers = $("#apicall-headers").val();
    const body = $("#apicall-body").val();
    $("#apicall-modal").modal('hide');
    if(stepnumber=='') {
        jsonSteps.push({
            httpmethod: httpmethod,
            url: url,
            body: body,
            headers: headers,
            response_type: "apicall"
        });
    } else {
        jsonSteps[stepnumber]={
            httpmethod: httpmethod,
            url: url,
            body: body,
            headers: headers,
            response_type: "apicall"
        }
    }
    updateStepsList();
    saveSteps();
}

function addRouteStep() {
    const stepnumber = $("#route-modal input[name='stepnumber']").val();
    const nomatch = $("#route-next-step-nomatch").val();
    const afterhours = $("#route-next-step-afterhours").val();
    const from = $("#route-next-step-from").val();
    const from_goto = $("#route-next-step-from_goto").val();
    const apivariable = $('#route-next-step-apivariable').val();
    const apivariablecontent = $('#route-next-step-apivariablecontent').val();
    const apivariablegoto = $('#route-next-step-apivariablegoto').val();

    const options = {};
    let optionNumber = 1;
    while (true) {
        const optionLabel = $("#route-modal input#route-option-label-" + optionNumber).val();
        if (!optionLabel) break;
        const nextStep = $("#route-modal input#route-next-step-" + optionNumber).val();
        options[optionLabel] = Number(nextStep);
        optionNumber++;
    }
    $("#route-modal").modal('hide');
    if(stepnumber=='') {
        jsonSteps.push({
            nomatch: nomatch,
            afterhours: afterhours,
            apivariable: apivariable,
            apivariablecontent: apivariablecontent,
            apivariablegoto: apivariablegoto,
            from: from,
            from_goto: from_goto,
            response_type: "route",
            options: options,
        });
    } else {
        jsonSteps[stepnumber]={
            nomatch: nomatch,
            afterhours: afterhours,
            apivariable: apivariable,
            apivariablecontent: apivariablecontent,
            apivariablegoto: apivariablegoto,
            from: from,
            from_goto: from_goto,
            response_type: "route",
            options: options,
        }
    }
    updateStepsList();
    saveSteps();
}



function addTransferStep() {
    const stepnumber = $("#transfer-step-modal input[name='stepnumber']").val();
    const question   = $("#transfer-step-modal textarea[name='question']").val();
    const department = $("#transfer-step-modal select[name='department']").val();
    $("#transfer-step-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: question,
         response_type: "transfer",
         next_action: "next",
         options: department
       });
    } else {
       jsonSteps[stepnumber]={
         body: question,
         response_type: "transfer",
         next_action: "next",
         options: department
       };
    }
    updateStepsList();
    saveSteps();
}

function addTagStep() {
    const stepnumber = $("#tag-step-modal input[name='stepnumber']").val();
    const tag   = $("#tag-step-modal input[name='tag']").val();
    $("#tag-step-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: tag,
         response_type: "tag",
         next_action: "next",
       });
    } else {
       jsonSteps[stepnumber]={
         body: tag,
         response_type: "tag",
         next_action: "next",
       };
    }
    updateStepsList();
    saveSteps();
}

function addCloseStep() {
    const stepnumber = $("#close-step-modal input[name='stepnumber']").val();
    const question   = $("#close-step-modal textarea[name='question']").val();
    const yescsat    = $('#yescsat').prop('checked');

    var response_type = 'close'

    if(yescsat===false) {
        // disable csat
        response_type = 'close^nocsat';
    }

    $("#close-step-modal").modal('hide');
    if(stepnumber=='') {
       jsonSteps.push({
         body: question,
         response_type: response_type,
         next_action: "end",
       });
    } else {
       jsonSteps[stepnumber]={
         body: question,
         response_type: response_type,
         next_action: "end",
       };
    }
    updateStepsList();
    saveSteps();
}

function removeFunction(stepIndex) {
    jsonFunctions.splice(stepIndex, 1);
    updateFunctionsList();
    saveFunctions();
}

function removeStep(stepIndex) {
    jsonSteps.splice(stepIndex, 1);
    updateStepsList();
    saveSteps();
}

function editFunction(stepIndex) {
  editFunctionStep(stepIndex);
}

function editStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  switch (step.response_type) {
    case "text":
      editTextQuestionStep(stepIndex);
      break;
    case "wait":
      editWaitStep(stepIndex);
      break;
    case "file":
      editFileStep(stepIndex);
      break;
    case "range":
      editRangeQuestionStep(stepIndex);
      break;
    case "menu":
      editMenuQuestionStep(stepIndex);
      break;
    case "transfer":
      editTransferStep(stepIndex);
      break;
    case "close":
      editCloseStep(stepIndex,1);
      break;
    case "close^nocsat":
      editCloseStep(stepIndex,0);
      break;
    case "tag":
      editTagStep(stepIndex);
      break;
    case "route":
      editRouteStep(stepIndex);
      break;
    case "apicall":
      editApiCallStep(stepIndex);
      break;
  }
}

function render_functions() {
   if($('#functions-list').length==0) {
       $('fieldset').append('<ul id="functions-list" style="margin-bottom:20px;"></ul>');
   }
   if($('#function-buttons-list').length==0) {
       $('fieldset').append('<div id="function-buttons-list" style="margin-bottom:20px;"></div>');
       $('#function-buttons-list').append('<button onClick="return newFunctionModal();" id="add-function" class="btn btn-default" data-trans="Add Function">Add Function</button> ');
   }

    if($('#function-modal').length==0) {
    $('body').append(`<div class="modal fade" id="function-modal" tabindex="-1" role="dialog" aria-labelledby="textQuestionModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="functionModalLabel" data-trans="Function">Function</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="functionname" data-trans="Name">Name</label>
            <input type=text name="functionname" class="form-control">
            <label for="functionurl" data-trans="URL">URL</label>
            <input type=text name="functionurl" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addFunction()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }


    updateFunctionsList();
}

function render_interactive() {

   if($('#steps-list').length==0) {
       $('fieldset').append('<ul id="steps-list" style="margin-bottom:20px; padding:0;" class="col-sm-11"></ul>');
   }

   if($('#buttons-list').length==0) {
       $('fieldset').append('<div id="buttons-list" style="margin-bottom:20px;" class="col-sm-11"></div>');

       $('#buttons-list').append('<select id="action-select" class="form-control"></select>');

       // Define the options
       var options = [
           { value: "", text: "Select to add new step" },
           { value: "newTextModal", text: "Add Text Question" },
           { value: "newFileModal", text: "Add Send File" },
           { value: "newRangeModal", text: "Add Range Question" },
           { value: "newMenuModal", text: "Add Menu Question" },
           { value: "newRouteModal", text: "Add Route Step" },
           { value: "newTransferModal", text: "Add Transfer Step" },
           { value: "newApiCallModal", text: "Add Api Call Step" },
           { value: "newTagModal", text: "Add Tag Step" },
           { value: "newCloseModal", text: "Add Close Step" },
           { value: "newWaitModal", text: "Add Wait Step" }
       ];

       // Add options to the select element
       $.each(options, function(i, option) {
           $('#action-select').append($('<option></option>')
               .attr('value', option.value)
               .text(option.text)
               .attr('data-trans', option.text)
           );
       });
   }

    if($('#file-step-modal').length==0) {
    $('body').append(`<div class="modal fade" id="file-step-modal" tabindex="-1" role="dialog" aria-labelledby="fileStepModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="fileStepModalLabel" data-trans="Send File">Send File</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="url" data-trans="URL">URL</label>
            <input type=text name="url" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addFileStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#text-wait-modal').length==0) {
    $('body').append(`<div class="modal fade" id="text-wait-modal" tabindex="-1" role="dialog" aria-labelledby="textWaitModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="textWaitModalLabel" data-trans="Wait Step">Wait Step</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="message" data-trans="Message">Message</label>
            <textarea name="message" class="form-control" rows=6></textarea>
            <label for="message" data-trans="Response">Response</label>
            <textarea name="response" class="form-control" rows=6></textarea>
            <label for="wait" data-trans="Wait">Wait</label>
            <input type="text" id="wait" name="wait" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addWaitStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }


    if($('#text-question-modal').length==0) {
    $('body').append(`<div class="modal fade" id="text-question-modal" tabindex="-1" role="dialog" aria-labelledby="textQuestionModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="textQuestionModalLabel" data-trans="Text Question">Text Question</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="question" data-trans="Question">Question</label>
            <textarea name="question" class="form-control" rows=6></textarea>
            <label for="validation" data-trans="Validation Regex">Validation Regex</label>
            <input type="text" id="validation" name="validation" class="form-control">
            <label for="incorrectmsg" data-trans="Invalid Reply Message">Invalid Reply Message</label>
            <input type="text" id="incorrectmsg" name="incorrectmsg" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addTextQuestionStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#range-question-modal').length==0) {
    $('body').append(`<div class="modal fade" id="range-question-modal" tabindex="-1" role="dialog" aria-labelledby="rangeQuestionModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="rangeQuestionModalLabel" data-trans='Range Question'>Range Question</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="question" data-trans="Question">Question</label>
            <textarea name="question" class="form-control" rows=6></textarea>
            <label for="options" data-trans="Options (comma-separated)">Options (comma-separated):</label>
            <input type="text" name="options" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addRangeQuestionStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#menu-question-modal').length==0) {
    $('body').append(`<div class="modal fade" id="menu-question-modal" tabindex="-1" role="dialog" aria-labelledby="menuQuestionModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="menuQuestionModalLabel" data-trans='Menu Question'>Menu Question</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="question" data-trans="Question">Question</label>
            <textarea name="question" class="form-control" rows=6></textarea>
            <br>
            <div id="menu-options">
              </div>
            <button type="button" class="btn btn-primary" id="add-option-btn" onClick="return clickAddOption();" data-trans="Add Option">Add Option</button>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addMenuQuestionStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#apicall-modal').length==0) {
    $('body').append(`<div class="modal fade" id="apicall-modal" tabindex="-1" role="dialog" aria-labelledby="menuApiCallLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="menuApiCallModalLabel" data-trans='Api Call Step'>Api Call Step</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <div class="row">
                <div class="col-sm-12">
                   <label for="apicall-httpmethod" data-trans="HTTP Method">HTTP Method</label>
                   <select id="apicall-httpmethod" class="form-control" name="httpmethod">
                       <option value='POST'>POST</option>
                       <option value='POSTJSON'>POST (JSON)</option>
                       <option value='GET'>GET</option>
                       <option value='PUT'>PUT</option>
                       <option value='DELETE'>DELETE</option>
                   </select>
                </div>
            </div>
            <br/>
            <div class="row">
                <div class="col-sm-12">
                   <label for="apicall-url" data-trans="URL">URL</label>
                   <input type="text" id="apicall-url" class="form-control" value="">
                </div>
            </div>
            <br/>
            <div class="row">
                <div class="col-sm-12">
                   <label for="apicall-headers" data-trans="Headers">Headers</label>
                   <textarea id="apicall-headers" class="form-control"></textarea>
                </div>
            </div>
            <br/>
            <div class="row">
                <div class="col-sm-12">
                   <label for="apicall-body" data-trans="Body">Body</label>
                   <textarea id="apicall-body" class="form-control"></textarea>
                </div>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addApiCallStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#route-modal').length==0) {
    $('body').append(`<div class="modal fade" id="route-modal" tabindex="-1" role="dialog" aria-labelledby="menuRouteModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="menuRouteModalLabel" data-trans='Route Step'>Route Step</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>

            <div class="row">
                <div class="col-sm-6">
                   <label for="route-next-step-from" data-trans="If from contains">If from contains</label>
                   <input type="text" id="route-next-step-from" class="form-control" value="">
                </div>
                <div class="col-sm-6">
                   <label for="route-next-step-from_goto" data-trans="Go to step">Go to step</label>
                   <input type="text" id="route-next-step-from_goto" class="form-control" value="">
                </div>
            </div><br/>

            <div class="row">
                <div class="col-sm-12">
                   <label for="route-next-step-afterhours" data-trans="If after hours go to step">If after hours go to step</label>
                   <input type="text" id="route-next-step-afterhours" class="form-control" value="">
                </div>
            </div><br/>

            <div class="row">
                <div class="col-sm-6">
                   <label for="route-next-step-apivariable" data-trans="If API response">If API response</label>
                   <input type="text" id="route-next-step-apivariable" class="form-control" value="">
                </div>
                <div class="col-sm-4">
                   <label for="route-next-step-apivariablecontent" data-trans="contains">contains</label>
                   <input type="text" id="route-next-step-apivariablecontent" class="form-control" value="">
                </div>
                <div class="col-sm-2">
                   <label for="route-next-step-apivariablegoto" data-trans="Go to step">Go to step</label>
                   <input type="text" id="route-next-step-apivariablegoto" class="form-control" value="">
                </div>
            </div><br/>


            <div class="row"><div class="col-sm-12">
            <div id="route-options">
            </div>

            <div class="row">
                <div class="col-sm-12">
                   <label for="route-next-step-nomatch" data-trans="If no match go to step">If no match go to step</label>
                   <input type="text" id="route-next-step-nomatch" class="form-control" value="">
                </div>
            </div><br/>

            <button type="button" class="btn btn-primary" id="add-option-btn" onClick="return clickAddRouteOption();" data-trans="Add Option">Add Option</button>
            </div></div>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addRouteStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    if($('#transfer-step-modal').length==0) {
    $('body').append(`<div class="modal fade" id="transfer-step-modal" tabindex="-1" role="dialog" aria-labelledby="transferStepModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="transferStepModalLabel" data-trans="Transfer Step">Transfer Step</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="question" data-trans="Message">Message</label>
            <textarea name="question" class="form-control" rows=3></textarea>
            <br>
            <label for="department" data-trans="Transfer to Service Group">Transfer to Service Group</label>
            <select name="department" id="department" class="form-control"></select>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addTransferStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);

    let servgroupstring = 'Service Groups';
    let botsstring = 'Bots';
    let allstring = 'All Extensions';

    if(typeof(lang)!='undefined') {
        if(typeof(lang['Service Groups'])!='undefined') {
            servgroupstring = lang['Service Groups'];
        }
        if(typeof(lang['Bots'])!='undefined') {
            botsstring = lang['Bots'];
        }
        if(typeof(lang['All Extensions'])!='undefined') {
            allstring = lang['All Extensions'];
        }
    }

    fetch('plugins/phonepro/menu/api.php?action=listGroups').then((response)=>response.json()).then((data)=> {
        og = $('<optgroup/>').attr('label', servgroupstring).attr('title','fas fa-users');
        og.append($(`<option value='ALL' title='fas fa-users'>${allstring}</option>`));
        for (const [key, myvalue] of Object.entries(data)) {
            if(key!='All Extensions') {
                og.append($(`<option value='[${key}]' title='${key}'>${key}</option>`));
                transfer_dictionary[key]=key;
                sanitized_id = key.replace( /[^a-zA-Z0-9\-_]/g, "");
                $('#tag'+sanitized_id).text(key);
            }
        }
        $('#department').append(og);
        updateStepsList();
    });

    fetch('plugins/phonepro/menu/api.php?action=listBots').then((response)=>response.json()).then((data)=> {
        og = $('<optgroup/>').attr('label', botsstring).attr('title','fas fa-robot');
        for (const [key, myvalue] of Object.entries(data)) {
            og.append($(`<option value='{${key}}' title='${myvalue}'>${myvalue}</option>`));
            transfer_dictionary['{'+key+'}']=myvalue;
            sanitized_id = key.replace( /[^a-zA-Z0-9\-_]/g, "");
            $('#tag'+sanitized_id).text(myvalue);
        }
        $('#department').append(og);
        updateStepsList();
    });

    }

    if($('#close-step-modal').length==0) {
    $('body').append(`<div class="modal fade" id="close-step-modal" tabindex="-1" role="dialog" aria-labelledby="closeStepModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="closeStepModalLabel" data-trans="End Conversation">End Conversation</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="question" data-trans="Message">Message</label>
            <textarea name="question" class="form-control" rows=3></textarea>
            <br/>
            <label for="yescsat" data-trans="Enable CSAT">Enable CSAT</label>
            <input type="checkbox" class='chk3' name='yescsat' id='yescsat' data-toggle='toggle'>

          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addCloseStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);

     $('#yescsat').bootstrapToggle({size:'mini'});

    }

    if($('#tag-step-modal').length==0) {
    $('body').append(`<div class="modal fade" id="tag-step-modal" tabindex="-1" role="dialog" aria-labelledby="tagStepModalLabel">
      <div class="modal-dialog" role="document">
        <div class="modal-content">
          <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="tagStepModalLabel" data-trans="Tag Conversation">Tag Conversation</h4>
          </div>
          <div class="modal-body">
            <input type=hidden name='stepnumber' value=''>
            <label for="tag" data-trans="Tag">Tag</label>
            <input type="text" name="tag" class="form-control">
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-default" data-dismiss="modal" data-trans="Close">Close</button>
            <button type="button" class="btn btn-primary" onclick="addTagStep()" data-trans="Save Changes">Save Changes</button>
          </div>
        </div>
      </div>
    </div>`);
    }

    updateStepsList();
}

function editTagStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#tag-step-modal input[name='stepnumber']").val(stepIndex);
  $("#tag-step-modal input[name='tag']").val(step.body);
  $("#tag-step-modal").modal("show");
}

function editCloseStep(stepIndex,csatenabled) {
  const step = jsonSteps[stepIndex];
  $("#close-step-modal input[name='stepnumber']").val(stepIndex);
  $("#close-step-modal textarea[name='question']").val(step.body);
  if(csatenabled == 1) {
      $('#yescsat').prop('checked', true).change()
  }
  $("#close-step-modal").modal("show");
}

function editTransferStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#transfer-step-modal input[name='stepnumber']").val(stepIndex);
  $("#transfer-step-modal textarea[name='question']").val(step.body);
  $("#transfer-step-modal select[name='department']").val(step.options);
  $("#transfer-step-modal").modal("show");
}

function editFileStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#file-step-modal input[name='stepnumber']").val(stepIndex);
  $("#file-step-modal input[name='url']").val(step.body);
  $("#file-step-modal").modal("show");
}

function editWaitStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#text-wait-modal input[name='stepnumber']").val(stepIndex);
  $("#text-wait-modal textarea[name='message']").val(step.body);
  $("#text-wait-modal textarea[name='response']").val(step.response);
  $("#text-wait-modal input[name='wait']").val(step.wait);
  $("#text-wait-modal").modal("show");
}

function editTextQuestionStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#text-question-modal input[name='stepnumber']").val(stepIndex);
  $("#text-question-modal textarea[name='question']").val(step.body);
  $("#text-question-modal input[name='validation']").val(step.validation);
  $("#text-question-modal input[name='incorrectmsg']").val(step.incorrectmsg);
  $("#text-question-modal").modal("show");
}

function editRangeQuestionStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#range-question-modal input[name='stepnumber']").val(stepIndex);
  $("#range-question-modal textarea[name='question']").val(step.body);
  $("#range-question-modal input[name='options']").val(step.options.join(","));
  $("#range-question-modal").modal("show");
}

function editMenuQuestionStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#menu-question-modal input[name='stepnumber']").val(stepIndex);
  $("#menu-question-modal textarea[name='question']").val(step.body);
  $("#menu-options").empty();
  var i = 1;
  for (const option in step.options) {
    const nextStep = step.options[option];
    addOptionToMenuModal(i, option, nextStep);
    i++;
  }
  doTrans();
  $("#menu-question-modal").modal("show");
}

function editApiCallStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#apicall-modal input[name='stepnumber']").val(stepIndex);
  $('#apicall-httpmethod').val(step.httpmethod);
  $('#apicall-url').val(step.url);
  $('#apicall-headers').val(step.headers);
  $('#apicall-body').val(step.body);
  doTrans();
  $("#apicall-modal").modal("show");
}

function editRouteStep(stepIndex) {
  const step = jsonSteps[stepIndex];
  $("#route-modal input[name='stepnumber']").val(stepIndex);

  $('#route-next-step-nomatch').val(step.nomatch); // If no match
  $('#route-next-step-afterhours').val(step.afterhours); // If after hours
  $('#route-next-step-from').val(step.from); // If after hours
  $('#route-next-step-from_goto').val(step.from_goto); // If after hours

  $('#route-next-step-apivariable').val(step.apivariable);
  $('#route-next-step-apivariablecontent').val(step.apivariablecontent);
  $('#route-next-step-apivariablegoto').val(step.apivariablegoto);

  $("#route-options").empty();
  var i = 1;
  for (const option in step.options) {
    const nextStep = step.options[option];
    addRouteOptionToMenuModal(i, option, nextStep);
    i++;
  }
  doTrans();
  $("#route-modal").modal("show");
}

function clickAddRouteOption() {
    var i = $('.route-option-label').length;
    i++;
    addRouteOptionToMenuModal(i,'', '');
    doTrans();
    return false;
}

function clickAddOption() {
    var i = $('.option-label').length;
    i++;
    addOptionToMenuModal(i,'', '');
    doTrans();
    return false;
}

function addRouteOptionToMenuModal(i, optionValue, nextStep) {
  $("#route-options").append(`
    <div class="row"><div class="col-sm-6">
      <label for="route-option-label-${i}" data-trans="If previous response contains" >If previous response contains</label>
      <input type="text" id="route-option-label-${i}" class="form-control route-option-label" value="${optionValue}">
      </div>
      <div class="col-sm-6">
      <label for="route-next-step-${i}" data-trans="Go to step">Go to step</label>
      <input type="text" id="route-next-step-${i}" class="form-control" value="${nextStep}">
      </div>
    </div><br/>
  `);
}

function addOptionToMenuModal(i, optionValue, nextStep) {
  $("#menu-options").append(`
    <div class="row"><div class="col-sm-6">
      <label for="option-label-${i}" data-trans="If user selects">If user selects</label>
      <input type="text" id="option-label-${i}" class="form-control option-label" value="${optionValue}">
      </div>
      <div class="col-sm-6">
      <label for="next-step-${i}" data-trans="Go to step">Go to step</label>
      <input type="text" id="next-step-${i}" class="form-control" value="${nextStep}">
      </div>
    </div><br/>
  `);
}

function updateFunctionsList() {
  $("#functions-list").empty();
  for (let i = 0; i < jsonFunctions.length; i++) {
   const listItem = $(
      `<li style="line-height:2em;margin-bottom:2px;" class="list-group-item"><span style='font-weight:700;'>${jsonFunctions[i]['name']}</span> &rarr; <span>${jsonFunctions[i]['url']}</span></li>`
    );
    // Add edit button for each step
    listItem.append(
      `<button type="button" class="btn btn-sm btn-primary edit-fstep" style='float:left;margin-right:3px;' data-step-index="${i}"><i class="fa fa-pencil" data-toggle="tooltip" data-original-title="Edit"></i></button>`
    );

    // Add remove button for each step
    listItem.append(
      `<button type="button" class="btn btn-sm btn-danger remove-fstep fjconf" style='float:left; margin-right:10px;' data-step-index="${i}"><i class="fa fa-trash" data-toggle="tooltip" data-original-title="Delete"></i></button>`
    );

    $("#functions-list").append(listItem);
  }

  $(".edit-fstep").click(function () {
    const stepIndex = $(this).data("step-index");
    editFunction(stepIndex);
  });

  $('.fjconf').jConf( { 
      'sText': lang['Are you sure?'], 
      'okBtn': lang['yes'], 
      'noBtn': lang['no'],
      'callResult': function(data){
          if(data.inputVal=='jconfBtnOK') {
              stepIndex = data.oElem.data("step-index");
              removeFunction(stepIndex);
          } else {
              return false;
         }
      }
  });


  doTrans();

}

function updateStepsList() {
 
  $("#steps-list").empty();

  for (let i = 0; i < jsonSteps.length; i++) {
    const step = jsonSteps[i];
    let stepType;
    switch (step.response_type) {
      case "text":
        stepType = "Text Question";
        break;
      case "file":
        stepType = "Send File";
        break;
      case "range":
        stepType = "Range Question";
        break;
      case "menu":
        stepType = "Menu Question";
        break;
      case "route":
        stepType = "Route Step";
        break;
      case "transfer":
        stepType = "Transfer Step";
        break;
      case "tag":
        stepType = "Tag Conversation";
        break;
      case "close":
        stepType = "End Conversation";
        break;
      case "close^nocsat":
        stepType = "End Conversation";
        break;
      case "apicall":
        stepType = "Api Call";
        break;
      case "wait":
        stepType = "Wait";
        break;
    }

    const listItem = $(
      `<li style="line-height:2em;margin-bottom:2px;" class="list-group-item"><b>${i}</b>. <span style='font-weight:700;' data-trans="${stepType}">${stepType}</span></li>`
    );
    // Add edit button for each step
    listItem.append(
      `<button type="button" class="btn btn-sm btn-primary edit-step" style='float:left;margin-right:3px;' data-step-index="${i}"><i class="fa fa-pencil" data-toggle="tooltip" data-original-title="Edit"></i></button>`
    );

    // Add remove button for each step
    listItem.append(
      `<button type="button" class="btn btn-sm btn-danger remove-step jconf" style='float:left; margin-right:10px;' data-step-index="${i}"><i class="fa fa-trash" data-toggle="tooltip" data-original-title="Delete"></i></button>`
    );

    if(step.response_type=='menu') {
         var printopt = [];
         for (const [key, value] of Object.entries(step.options)) {
            if(typeof(jsonSteps[value])=='undefined') {
                // destination step does not exist
                printopt.push(`${key}&rarr;<span style='color:red;'>${value}</span>`);
            } else {
                printopt.push(`${key}&rarr;${value}`);
            }
         }
         var finalprint = printopt.join(', ');
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${finalprint}</span>`
         );

    } else if(step.response_type=='route') {

         step.msg = '';
         if(step.nomatch!='') {
             step.msg = lang['If no match go to step']+" "+step.nomatch;
         }
         if(step.afterhours!='' && step.afterhours !== undefined) {
             step.msg += '<br/>'+ lang['If after hours go to step']+" "+step.afterhours;
         }
         if(step.from!='' && step.from !== undefined) {
             step.msg += '<br/>'+ lang['If from contains']+" "+step.from+" &rarr; "+step.from_goto;
         }

         var printopt = [];
         for (const [key, value] of Object.entries(step.options)) {
            if(typeof(jsonSteps[value])=='undefined') {
                // destination step does not exist
                printopt.push(`${key}&rarr;<span style='color:red;'>${value}</span>`);
            } else {
                printopt.push(`${key}&rarr;${value}`);
            }
         }
         var finalprint = printopt.join(', ');
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${finalprint}</span>`
         );

    } else if(step.response_type=='wait') {
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${step.wait}</span>`
         );
    } else if(step.response_type=='apicall') {
         var method = step.httpmethod;
         if(step.httpmethod=='POSTJSON') {
             method = 'POST (json)';
         }
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${method}</span>`
         );
    } else if(step.response_type=='transfer') {
         if(typeof(step.options)=='undefined') {
            step.options='';
         }
         var tagname='';
         if (step.options.startsWith('[') && step.options.endsWith(']')) {
             tagname = step.options.slice(1,-1);
         } else {
             tagname = step.options;
         }
         tagname = transfer_dictionary[tagname];
         var sanitized_id = step.options.replace( /[^a-zA-Z0-9\-_]/g, "");
         listItem.append(
           `<span class="xbadge" id="tag${sanitized_id}" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${tagname}</span>`
         );
    } else if(step.response_type=='tag') {
         let nextprint = lang[step.next_action];
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${nextprint}</span>`
         );

    } else {
       if(typeof(step.next_action)!='undefined') {
         if(typeof(lang[step.next_action])!='undefined') {
             nextprint = lang[step.next_action];
         } else {
             nextprint = step.next_action;
         }
         listItem.append(
           `<span class="xbadge" style="float:right;padding:0px 5px;background-color:#5acea6;border-radius:10px;">${nextprint}</span>`
         );
       }
    }
    if(step.response_type=='apicall') {
        listItem.append(`<div><pre style="display:inline-grid; width:100%; margin-top:3px;">${step.url}</pre></div>`);
    } else if(step.response_type=='route') {
        listItem.append(`<div><pre style="display:inline-grid; width:100%; margin-top:3px;">${step.msg}</pre></div>`);
    } else if(step.response_type=='wait') {
        listItem.append(`<div><pre style="display:inline-grid; width:100%; margin-top:3px;">${step.body}</pre></div>`);
    } else {
        listItem.append(`<div><pre style="display:inline-grid; width:100%; margin-top:3px;">${step.body}</pre></div>`);
    }
    $("#steps-list").append(listItem);
  }

  // Add click handlers for edit and remove buttons
  $(".edit-step").click(function () {
    const stepIndex = $(this).data("step-index");
    editStep(stepIndex);
  });

  $('.jconf').jConf( { 
      'sText': lang['Are you sure?'],
      'okBtn': lang['yes'],
      'noBtn': lang['no'],
      'callResult': function(data){
          if(data.inputVal=='jconfBtnOK') {
              stepIndex = data.oElem.data("step-index");
              removeStep(stepIndex);
          } else {
              return false;
         }
      }
  });

  doTrans();

}

function saveSteps() {
   current = JSON.parse($('#chatbot_template').val());
   current['steps']=JSON.stringify(jsonSteps);
   $('input').each(function() {
      elid = $(this).attr('id');
      if(typeof(elid)!='undefined') {
          if($(this).attr('id').indexOf('dynamic_')==0) {
              current[$(this).attr('id').substr(8)]=$(this).val();
          }
      }
   });
   $('#chatbot_template').val(JSON.stringify(current));
}


function saveFunctions() {
   current = JSON.parse($('#chatbot_template').val());
   current['functions']=JSON.stringify(jsonFunctions);
   $('input').each(function() {
      elid = $(this).attr('id');
      if(typeof(elid)!='undefined') {
          if($(this).attr('id').indexOf('dynamic_')==0) {
              current[$(this).attr('id').substr(8)]=$(this).val();
          }
      }
   });
   $('#chatbot_template').val(JSON.stringify(current));
}

function refresh_meta_templates() {
    const templateJson = $('#chatbroker_template').val();

    try {
        const templateData = JSON.parse(templateJson);
        const wabaId = templateData.WABA_ID;
        const token = templateData.PAGE_ACCESS_TOKEN;

        console.log('Fetching templates for WABA ID:', wabaId);

        fetch(`https://graph.facebook.com/v16.0/${wabaId}/message_templates`, {
            method: 'GET',
            headers: {
                'Authorization': `Bearer ${token}`
            }
        })
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP error! status: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            // Get the templates data (assuming it's in data.data)
            const templates = data.data;
            const content = JSON.stringify(templates, null, 2); // Pretty-print JSON

            // Update the textarea and CodeMirror instance
            $('#chatbroker_whatsapp_templates').val(content);
            // Assuming myCodeMirror is the CodeMirror instance
            if (typeof myCodeMirrorTemplates !== 'undefined') {
                myCodeMirrorTemplates.setValue(content);
                myCodeMirrorTemplates.refresh();
            }

            console.log('Templates refreshed successfully');
        })
        .catch(error => {
            console.error('Error fetching templates:', error);
            alert('Error fetching templates: ' + error.message);
        });

    } catch (error) {
        console.error("Failed to parse JSON:", error);
        alert("Invalid template configuration: " + error.message);
    }

    return false;
}
