<?php
// redirects
$targetFile = 'openai_assistant_bot.php';

// Get the current request method
$method = $_SERVER['REQUEST_METHOD'];

// Preserve the original request URI parameters if this is a GET request
if (!empty($_SERVER['QUERY_STRING'])) {
    $queryString = $_SERVER['QUERY_STRING'];
    $separator = strpos($targetFile, '?') === false ? '?' : '&';
    $targetFile .= $separator . $queryString;
}

// For POST/PUT/PATCH/DELETE requests, we need to preserve the input data
if ($method !== 'GET') {
    // Get the raw input data
    $inputData = file_get_contents('php://input');
    
    // Initialize cURL to forward the request
    $ch = curl_init();
    
    // Set the target URL (using absolute path from server root)
    $targetUrl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . 
                 "://$_SERVER[HTTP_HOST]" . dirname($_SERVER['REQUEST_URI']) . "/$targetFile";

    curl_setopt($ch, CURLOPT_URL, $targetUrl);
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $inputData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    
    // Forward headers (excluding some that shouldn't be forwarded)
    $headers = [];
    foreach (getallheaders() as $name => $value) {
        if (!in_array(strtolower($name), ['host', 'content-length'])) {
            $headers[] = "$name: $value";
        }
    }
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    
    // Execute and output the response
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    
    http_response_code($httpCode);
    echo $response;
    
    curl_close($ch);
    exit;
}

header("Location: $targetFile", true, 307); // 307 preserves request method
exit;
?>
