<?php
// PHP Port of BoringAvatars.com

class AvatarBeam {

    public $props;
    public $SIZE;
    public $square;
    public $name;
    public $colors;
    public $data;

    public function __construct($name, $colors, $props = null) {
        if (is_null($props)) {
            $this->props = array("square" => false, "size" => 36);
        } else {
            $this->props = $props;
        }

        if (!isset($this->props['size'])) {
            $this->props['size'] = 36;
            echo 'size undfeind';
        }
        if (!isset($this->props['square'])) {
            $this->props['square'] = false;
        }

        $this->SIZE = 36;
        $this->square = $this->props['square'];

        $this->name = $name;
        $this->colors = $colors;
        $this->data = $this->generateData();
    }

    private function hashCode($str) {
        $hash = 0;
        if (strlen($str) === 0) {
            return $hash;
        }
        for ($i = 0; $i < strlen($str); $i++) {
            $char = ord($str[$i]);
            $hash = (($hash << 5) - $hash) + $char;
            $hash = $hash & $hash; // Convert to 32-bit integer
        }
        return $hash;
    }

    private function getRandomColor($seed, $colors, $range) {
        $index = $seed % $range;
        if ($index < 0) {
            $index = abs($index);
        }
        return $colors[$index];
    }

    private function getUnit($seed, $max, $factor = 1) {
        return (abs($seed) % $max) * $factor;
    }

    private function getBoolean($seed, $probability) {
        return abs($seed) % $probability === 0;
    }

    private function getContrast($background) {
        // Convert the background color to RGB
        $hexToRgb = function($hex) {
            $shorthandRegex = '/^#?([a-f\d])([a-f\d])([a-f\d])$/i';
            $hex = preg_replace_callback($shorthandRegex, function($matches) {
                    return $matches[1] . $matches[1] . $matches[2] . $matches[2] . $matches[3] . $matches[3];
                    }, $hex);

            $regex = '/^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i';
            preg_match($regex, $hex, $result);
            return $result
                ? array(
                        'r' => hexdec($result[1]),
                        'g' => hexdec($result[2]),
                        'b' => hexdec($result[3]),
                       )
                : null;
        };

        // Get the luminance of a color
        $getLuminance = function($color) {
            $sRGB = array_map(function($c) {
                    $s = $c / 255;
                    return $s <= 0.03928 ? $s / 12.92 : pow(($s + 0.055) / 1.055, 2.4);
                    }, $color);

            return 0.2126 * $sRGB[0] + 0.7152 * $sRGB[1] + 0.0722 * $sRGB[2];
        };

        // Check if the luminance is dark or light
        function isDarkColor($color) {
            $brightness = ($color['r'] * 299 + $color['g'] * 587 + $color['b'] * 114) / 1000;
            return $brightness < 128;
        };

        // Get the contrasted foreground color based on the luminance
        $getForegroundContrastColor = function($color) {
            return isDarkColor($color) ? "#FFFFFF" : "#000000";
        };

        // Convert the background color to RGB
        $rgbColor = $hexToRgb($background);

        // Get the contrasted foreground color
        $foregroundColor = $getForegroundContrastColor($rgbColor);

        return $foregroundColor;
    }


    private function generateData() {
        // Implementation of the generateData function...
        $numFromName = $this->hashCode($this->name);
        $range = $this->colors ? count($this->colors) : 0;
        $wrapperColor = $this->getRandomColor($numFromName, $this->colors, $range);
        $preTranslateX = $this->getUnit($numFromName, 10, 1);
        $wrapperTranslateX = $preTranslateX < 5 ? $preTranslateX + $this->SIZE / 9 : $preTranslateX;
        $preTranslateY = $this->getUnit($numFromName, 10, 2);
        $wrapperTranslateY = $preTranslateY < 5 ? $preTranslateY + $this->SIZE / 9 : $preTranslateY;

        $data = array(
                'wrapperColor' => $wrapperColor,
                'faceColor' => $this->getContrast($wrapperColor),
                'backgroundColor' => $this->getRandomColor($numFromName + 13, $this->colors, $range),
                'wrapperTranslateX' => $wrapperTranslateX,
                'wrapperTranslateY' => $wrapperTranslateY,
                'wrapperRotate' => $this->getUnit($numFromName, 360),
                'wrapperScale' => 1 + $this->getUnit($numFromName, $this->SIZE / 12) / 10,
                'isMouthOpen' => $this->getBoolean($numFromName, 2),
                'isCircle' => $this->getBoolean($numFromName, 1),
                'eyeSpread' => $this->getUnit($numFromName, 5),
                'mouthSpread' => $this->getUnit($numFromName, 3),
                'faceRotate' => $this->getUnit($numFromName, 10, 3),
                'faceTranslateX' => $wrapperTranslateX > $this->SIZE / 6 ? $wrapperTranslateX / 2 : $this->getUnit($numFromName, 8, 1),
                'faceTranslateY' => $wrapperTranslateY > $this->SIZE / 6 ? $wrapperTranslateY / 2 : $this->getUnit($numFromName, 7, 2),
                );

        return $data;
    }


    function createSVGElement($tagName) {
        $element = new DOMDocument();
        return $element->createElementNS('http://www.w3.org/2000/svg', $tagName);
    }

    function setAttributes($element, $attributes) {
        // Implementation of the setAttributes function...
        foreach ($attributes as $attr => $value) {
            if ($value !== undefined) {
                $element->setAttribute($attr, $value);
            }
        }
    }

    function appendChild($parent, $child) {
        $importedChild = $parent->ownerDocument->importNode($child, true);
        $parent->appendChild($importedChild);
    }

    public function render() {
        $svg = $this->createSVGElement('svg');
        $this->setAttributes($svg, array(
                    'viewBox' => '0 0 ' . $this->SIZE . ' ' . $this->SIZE,
                    'fill' => 'none',
                    'role' => 'img',
                    'xmlns' => 'http://www.w3.org/2000/svg',
                    'width' => $this->props['size'],
                    'height' => $this->props['size']
                    ));

        if ($this->title) {
            $titleElement = $this->createSVGElement('title');
            $titleElement->textContent = $this->name;
            $this->appendChild($svg, $titleElement);
        }

        $mask = $this->createSVGElement('mask');
        $this->setAttributes($mask, array(
                    'id' => 'mask__beam',
                    'maskUnits' => 'userSpaceOnUse',
                    'x' => 0,
                    'y' => 0,
                    'width' => $this->SIZE,
                    'height' => $this->SIZE
                    ));

        $rect = $this->createSVGElement('rect');
        $this->setAttributes($rect, array(
                    'width' => $this->SIZE,
                    'height' => $this->SIZE,
                    'rx' => $this->square ? null : $this->SIZE * 2,
                    'fill' => '#FFFFFF'
                    ));

        $this->appendChild($mask, $rect);
        $this->appendChild($svg, $mask);

        $group = $this->createSVGElement('g');
        $this->setAttributes($group, array(
                    'mask' => 'url(#mask__beam)'
                    ));

        $backgroundRect = $this->createSVGElement('rect');
        $this->setAttributes($backgroundRect, array(
                    'width' => $this->SIZE,
                    'height' => $this->SIZE,
                    'fill' => $this->data['backgroundColor']
                    ));
        $this->appendChild($group, $backgroundRect);

        $wrapperRect = $this->createSVGElement('rect');
        $this->setAttributes($wrapperRect, array(
                    'x' => 0,
                    'y' => 0,
                    'width' => $this->SIZE,
                    'height' => $this->SIZE,
                    'transform' => 'translate(' . $this->data['wrapperTranslateX'] . ' ' . $this->data['wrapperTranslateY'] . ') rotate(' . $this->data['wrapperRotate'] . ' ' . $this->SIZE / 2 . ' ' . $this->SIZE / 2 . ') scale(' . $this->data['wrapperScale'] . ')',
                        'fill' => $this->data['wrapperColor'],
                        'rx' => $this->data['isCircle'] ? $this->SIZE : $this->SIZE / 6
                        ));
                $this->appendChild($group, $wrapperRect);

                $faceGroup = $this->createSVGElement('g');
                $this->setAttributes($faceGroup, array(
                        'transform' => 'translate(' . $this->data['faceTranslateX'] . ' ' . $this->data['faceTranslateY'] . ') rotate(' . $this->data['faceRotate'] . ' ' . $this->SIZE / 2 . ' ' . $this->SIZE / 2 . ')'
                            ));

                    if ($this->data['isMouthOpen']) {
                    $mouthPath = $this->createSVGElement('path');
                    $this->setAttributes($mouthPath, array(
                                'd' => 'M15 ' . (19 + $this->data['mouthSpread']) . 'c2 1 4 1 6 0',
                                'stroke' => $this->data['faceColor'],
                                'fill' => 'none',
                                'strokeLinecap' => 'round'
                                ));
                    $this->appendChild($faceGroup, $mouthPath);
                    } else {
                    $mouthPath = $this->createSVGElement('path');
                    $this->setAttributes($mouthPath, array(
                                'd' => 'M13,' . (19 + $this->data['mouthSpread']) . ' a1,0.75 0 0,0 10,0',
                                'fill' => $this->data['faceColor']
                                ));
                    $this->appendChild($faceGroup, $mouthPath);
                    }

                    $leftEyeRect = $this->createSVGElement('rect');
                    $this->setAttributes($leftEyeRect, array(
                                'x' => 14 - $this->data['eyeSpread'],
                                'y' => 14,
                                'width' => 1.5,
                                'height' => 2,
                                'rx' => 1,
                                'stroke' => 'none',
                                'fill' => $this->data['faceColor']
                                ));
                    $this->appendChild($faceGroup, $leftEyeRect);

                    $rightEyeRect = $this->createSVGElement('rect');
                    $this->setAttributes($rightEyeRect, array(
                                'x' => 20 + $this->data['eyeSpread'],
                                'y' => 14,
                                'width' => 1.5,
                                'height' => 2,
                                'rx' => 1,
                                'stroke' => 'none',
                                'fill' => $this->data['faceColor']
                                ));
                    $this->appendChild($faceGroup, $rightEyeRect);

                    $this->appendChild($group, $faceGroup);
                    $this->appendChild($svg, $group);


                    $element = new DOMDocument();
                    $element->appendChild($element->importNode($svg,true));
                    $svgString = $element->saveHTML();

                    return $svgString;
    }

}

